/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.model;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.sourcegen.model.AbstractElementBuilder;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.MethodDef;
import io.micronaut.sourcegen.model.ObjectDef;
import io.micronaut.sourcegen.model.PropertyDef;
import io.micronaut.sourcegen.model.TypeDef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class ObjectDefBuilder<ThisType>
extends AbstractElementBuilder<ThisType> {
    protected final List<MethodDef> methods = new ArrayList<MethodDef>();
    protected final List<PropertyDef> properties = new ArrayList<PropertyDef>();
    protected final List<TypeDef> superinterfaces = new ArrayList<TypeDef>();
    protected final List<ObjectDef> innerTypes = new ArrayList<ObjectDef>();

    protected ObjectDefBuilder(String name) {
        super(name);
    }

    @NonNull
    public final ThisType addMethod(@NonNull MethodDef method) {
        this.methods.add(method);
        return (ThisType)this.thisInstance;
    }

    @NonNull
    public final ThisType addMethods(@NonNull Collection<MethodDef> methods) {
        this.methods.addAll(methods);
        return (ThisType)this.thisInstance;
    }

    @NonNull
    public final ThisType addProperty(@NonNull PropertyDef property) {
        this.properties.add(property);
        return (ThisType)this.thisInstance;
    }

    @NonNull
    public final ThisType addSuperinterface(@NonNull TypeDef superinterface) {
        this.superinterfaces.add(superinterface);
        return (ThisType)this.thisInstance;
    }

    @NonNull
    public final ThisType addSuperinterfaces(@NonNull Collection<TypeDef> superinterfaces) {
        this.superinterfaces.addAll(superinterfaces);
        return (ThisType)this.thisInstance;
    }

    @NonNull
    public final ThisType addInnerType(@NonNull ObjectDef innerDef) {
        ClassTypeDef innerType = innerDef.asTypeDef();
        String newName = ClassTypeDef.of(this.name).getCanonicalName() + "$" + innerType.getSimpleName();
        this.innerTypes.add(innerDef.withClassName(new ClassTypeDef.ClassName(newName, true)));
        return (ThisType)this.thisInstance;
    }

    @NonNull
    public final ThisType addInnerType(@NonNull Collection<ObjectDef> innerDefs) {
        innerDefs.forEach(this::addInnerType);
        return (ThisType)this.thisInstance;
    }
}

