/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.boot.annotation;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.spring.annotation.AbstractSpringAnnotationMapper;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConditionalOnPropertyAnnotationMapper
extends AbstractSpringAnnotationMapper {
    public String getName() {
        return "org.springframework.boot.autoconfigure.condition.ConditionalOnProperty";
    }

    protected List<AnnotationValue<?>> mapInternal(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        String[] propertyNames = annotation.getValue(String[].class).orElseGet(() -> annotation.get((CharSequence)"name", String[].class).orElse(null));
        if (propertyNames != null) {
            String prefix = annotation.get((CharSequence)"prefix", String.class).orElse(null);
            boolean matchIfMissing = annotation.get((CharSequence)"matchIfMissing", Boolean.TYPE).orElse(false);
            String havingValue = annotation.get((CharSequence)"havingValue", String.class).orElse(null);
            ArrayList annotationValues = new ArrayList(propertyNames.length);
            for (String propertyName : propertyNames) {
                if (prefix != null) {
                    propertyName = prefix + "." + propertyName;
                }
                AnnotationValueBuilder builder = AnnotationValue.builder(Requires.class);
                builder.member(matchIfMissing ? "missingProperty" : "property", propertyName);
                if (havingValue != null) {
                    builder.value(havingValue);
                }
                annotationValues.add(builder.build());
            }
            return annotationValues;
        }
        return Collections.emptyList();
    }
}

