/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.boot.annotation;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.spring.annotation.AbstractSpringAnnotationMapper;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ConditionalOnBeanAnnotationMapper
extends AbstractSpringAnnotationMapper {
    public String getName() {
        return "org.springframework.boot.autoconfigure.condition.ConditionalOnBean";
    }

    protected List<AnnotationValue<?>> mapInternal(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        Object[] classValues = annotation.annotationClassValues("value");
        if (ArrayUtils.isNotEmpty((Object[])classValues)) {
            return Collections.singletonList(AnnotationValue.builder(Requires.class).member(this.requiresMethodName(), (AnnotationClassValue[])classValues).build());
        }
        Object[] types = annotation.stringValues(this.typesMemberName());
        if (ArrayUtils.isNotEmpty((Object[])types)) {
            AnnotationClassValue[] classesValues = (AnnotationClassValue[])Arrays.stream(types).map(AnnotationClassValue::new).toArray(AnnotationClassValue[]::new);
            return Collections.singletonList(AnnotationValue.builder(Requires.class).member(this.requiresMethodName(), classesValues).build());
        }
        return Collections.emptyList();
    }

    @NonNull
    protected String typesMemberName() {
        return "types";
    }

    @NonNull
    protected String requiresMethodName() {
        return "beans";
    }
}

