/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.boot.annotation;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.spring.annotation.AbstractSpringAnnotationMapper;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConditionalOnPropertyAnnotationMapper
extends AbstractSpringAnnotationMapper {
    public String getName() {
        return "org.springframework.boot.autoconfigure.condition.ConditionalOnProperty";
    }

    protected List<AnnotationValue<?>> mapInternal(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        Object[] propertyNames = annotation.stringValues("value");
        if (ArrayUtils.isEmpty((Object[])propertyNames)) {
            propertyNames = annotation.stringValues("name");
        }
        if (propertyNames != null) {
            String prefix = annotation.stringValue("prefix").orElse(null);
            boolean matchIfMissing = annotation.booleanValue("matchIfMissing").orElse(false);
            String havingValue = annotation.stringValue("havingValue").orElse(null);
            ArrayList annotationValues = new ArrayList(propertyNames.length);
            for (Object propertyName : propertyNames) {
                if (prefix != null) {
                    propertyName = prefix + "." + (String)propertyName;
                }
                AnnotationValueBuilder builder = AnnotationValue.builder(Requires.class);
                builder.member(matchIfMissing ? "missingProperty" : "property", (String)propertyName);
                if (havingValue != null) {
                    builder.value(havingValue);
                }
                annotationValues.add(builder.build());
            }
            return annotationValues;
        }
        return Collections.emptyList();
    }
}

