/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.context;

import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.spring.context.ManagedApplicationContext;
import io.micronaut.spring.context.env.MicronautEnvironment;
import io.micronaut.spring.context.event.MicronautApplicationEventPublisher;
import io.micronaut.spring.context.factory.MicronautBeanFactory;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.util.ObjectUtils;

@Singleton
@Secondary
public class MicronautApplicationContext
implements ManagedApplicationContext,
ConfigurableApplicationContext {
    private final io.micronaut.context.ApplicationContext micronautContext;
    private ConfigurableEnvironment environment;
    private MicronautBeanFactory beanFactory;
    private MessageSource messageSource;
    private ApplicationEventPublisher eventPublisher;
    private long startupDate;
    private String id = ObjectUtils.identityToString((Object)this);
    private ApplicationContext parent;

    @Inject
    public MicronautApplicationContext(io.micronaut.context.ApplicationContext micronautContext, ConfigurableEnvironment environment, MicronautBeanFactory beanFactory, ApplicationEventPublisher eventPublisher, @Nullable MessageSource messageSource) {
        this.micronautContext = micronautContext;
        this.environment = environment;
        this.beanFactory = beanFactory;
        this.messageSource = messageSource;
        this.eventPublisher = eventPublisher;
        this.startupDate = System.currentTimeMillis();
    }

    public MicronautApplicationContext() {
        this(io.micronaut.context.ApplicationContext.build());
    }

    public MicronautApplicationContext(ApplicationContextBuilder contextBuilder) {
        this.micronautContext = contextBuilder.build();
    }

    public String getId() {
        return this.id;
    }

    public String getApplicationName() {
        return this.micronautContext.getProperty("micronaut.application.name", String.class).orElse("application");
    }

    public String getDisplayName() {
        return this.getApplicationName();
    }

    public long getStartupDate() {
        return this.startupDate;
    }

    public ApplicationContext getParent() {
        return this.parent;
    }

    public AutowireCapableBeanFactory getAutowireCapableBeanFactory() throws IllegalStateException {
        return this.beanFactory;
    }

    public BeanFactory getParentBeanFactory() {
        if (this.parent != null) {
            return this.parent.getAutowireCapableBeanFactory();
        }
        return null;
    }

    public boolean containsLocalBean(String name) {
        return this.beanFactory.containsLocalBean(name);
    }

    public boolean containsBeanDefinition(String beanName) {
        return this.beanFactory.containsBeanDefinition(beanName);
    }

    public int getBeanDefinitionCount() {
        return this.beanFactory.getBeanDefinitionCount();
    }

    public String[] getBeanDefinitionNames() {
        return this.beanFactory.getBeanDefinitionNames();
    }

    public String[] getBeanNamesForType(ResolvableType type) {
        return this.beanFactory.getBeanNamesForType(type);
    }

    public String[] getBeanNamesForType(ResolvableType type, boolean includeNonSingletons, boolean allowEagerInit) {
        return this.beanFactory.getBeanNamesForType(type, includeNonSingletons, allowEagerInit);
    }

    public String[] getBeanNamesForType(Class<?> type) {
        return this.beanFactory.getBeanNamesForType(type);
    }

    public String[] getBeanNamesForType(Class<?> type, boolean includeNonSingletons, boolean allowEagerInit) {
        return this.beanFactory.getBeanNamesForType(type, includeNonSingletons, allowEagerInit);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type) throws BeansException {
        return this.beanFactory.getBeansOfType(type);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        return this.beanFactory.getBeansOfType(type, includeNonSingletons, allowEagerInit);
    }

    public String[] getBeanNamesForAnnotation(Class<? extends Annotation> annotationType) {
        return this.beanFactory.getBeanNamesForAnnotation(annotationType);
    }

    public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) throws BeansException {
        return this.beanFactory.getBeansWithAnnotation(annotationType);
    }

    public <A extends Annotation> A findAnnotationOnBean(String beanName, Class<A> annotationType) throws NoSuchBeanDefinitionException {
        return this.beanFactory.findAnnotationOnBean(beanName, annotationType);
    }

    public Object getBean(String name) throws BeansException {
        return this.beanFactory.getBean(name);
    }

    public <T> T getBean(String name, Class<T> requiredType) throws BeansException {
        return this.beanFactory.getBean(name, requiredType);
    }

    public Object getBean(String name, Object ... args) throws BeansException {
        return this.beanFactory.getBean(name, args);
    }

    public <T> T getBean(Class<T> requiredType) throws BeansException {
        return this.beanFactory.getBean(requiredType);
    }

    public <T> T getBean(Class<T> requiredType, Object ... args) throws BeansException {
        return this.beanFactory.getBean(requiredType, args);
    }

    public <T> ObjectProvider<T> getBeanProvider(Class<T> requiredType) {
        return this.beanFactory.getBeanProvider(requiredType);
    }

    public <T> ObjectProvider<T> getBeanProvider(ResolvableType requiredType) {
        return this.beanFactory.getBeanProvider(requiredType);
    }

    public boolean containsBean(String name) {
        return this.beanFactory.containsBean(name);
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return this.beanFactory.isSingleton(name);
    }

    public boolean isPrototype(String name) throws NoSuchBeanDefinitionException {
        return this.beanFactory.isPrototype(name);
    }

    public boolean isTypeMatch(String name, ResolvableType typeToMatch) throws NoSuchBeanDefinitionException {
        return this.beanFactory.isTypeMatch(name, typeToMatch);
    }

    public boolean isTypeMatch(String name, Class<?> typeToMatch) throws NoSuchBeanDefinitionException {
        return this.beanFactory.isTypeMatch(name, typeToMatch);
    }

    public Class<?> getType(String name) throws NoSuchBeanDefinitionException {
        return this.beanFactory.getType(name);
    }

    public Class<?> getType(String name, boolean allowFactoryBeanInit) throws NoSuchBeanDefinitionException {
        return this.beanFactory.getType(name, allowFactoryBeanInit);
    }

    public String[] getAliases(String name) {
        return this.beanFactory.getAliases(name);
    }

    public void publishEvent(Object event) {
        this.eventPublisher.publishEvent(event);
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        if (this.messageSource != null) {
            return this.messageSource.getMessage(code, args, defaultMessage, locale);
        }
        return null;
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        if (this.messageSource != null) {
            return this.messageSource.getMessage(code, args, locale);
        }
        return null;
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        if (this.messageSource != null) {
            return this.messageSource.getMessage(resolvable, locale);
        }
        return null;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setParent(ApplicationContext parent) {
        this.parent = parent;
        if (parent != null) {
            this.beanFactory.setParentBeanFactory((BeanFactory)parent.getAutowireCapableBeanFactory());
        }
    }

    public void setEnvironment(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    public ConfigurableEnvironment getEnvironment() {
        return this.environment;
    }

    public void addBeanFactoryPostProcessor(BeanFactoryPostProcessor postProcessor) {
        this.beanFactory.getBeanContext().registerSingleton((Object)postProcessor);
    }

    public void addApplicationListener(ApplicationListener<?> listener) {
        this.beanFactory.getBeanContext().registerSingleton(listener);
    }

    public void setClassLoader(ClassLoader classLoader) {
    }

    public void addProtocolResolver(ProtocolResolver resolver) {
        this.beanFactory.getBeanContext().registerSingleton((Object)resolver);
    }

    public void refresh() throws BeansException, IllegalStateException {
        this.stop();
        this.start();
    }

    public void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        if (this.environment instanceof MicronautEnvironment) {
            return (Resource[])((MicronautEnvironment)this.environment).getEnvironment().getResources(locationPattern).toArray(Resource[]::new);
        }
        return new Resource[0];
    }

    public Resource getResource(String location) {
        if (this.environment instanceof MicronautEnvironment) {
            return ((MicronautEnvironment)this.environment).getEnvironment().getResource(location).map(UrlResource::new).orElse(null);
        }
        return null;
    }

    public ClassLoader getClassLoader() {
        if (this.environment instanceof MicronautEnvironment) {
            return ((MicronautEnvironment)this.environment).getEnvironment().getClassLoader();
        }
        return null;
    }

    @Override
    public void close() {
        this.stop();
    }

    public boolean isActive() {
        return this.isRunning();
    }

    public ConfigurableListableBeanFactory getBeanFactory() throws IllegalStateException {
        return this.beanFactory;
    }

    public void start() {
        if (!this.isRunning()) {
            this.micronautContext.start();
            this.beanFactory = (MicronautBeanFactory)((Object)this.micronautContext.getBean(MicronautBeanFactory.class));
            this.environment = (ConfigurableEnvironment)this.micronautContext.getBean(MicronautEnvironment.class);
            this.eventPublisher = (ApplicationEventPublisher)this.micronautContext.getBean(MicronautApplicationEventPublisher.class);
            this.messageSource = this.micronautContext.findBean(MessageSource.class).orElse(null);
            this.startupDate = System.currentTimeMillis();
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.micronautContext.stop();
        }
    }

    public boolean isRunning() {
        return this.micronautContext.isRunning();
    }
}

