/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.context.env;

import io.micronaut.context.annotation.Primary;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.EnvironmentPropertySource;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.env.SystemPropertiesPropertySource;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.spring.beans.MicronautContextInternal;
import jakarta.inject.Singleton;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MissingRequiredPropertiesException;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.Profiles;
import org.springframework.util.Assert;

@Singleton
@Primary
@Internal
public class MicronautEnvironment
implements ConfigurableEnvironment,
MicronautContextInternal {
    private final Environment environment;
    private String[] requiredProperties;
    private ConfigurableConversionService conversionService;

    public MicronautEnvironment(Environment environment) {
        this.environment = environment;
    }

    public String[] getActiveProfiles() {
        return this.environment.getActiveNames().toArray(new String[0]);
    }

    public String[] getDefaultProfiles() {
        return StringUtils.EMPTY_STRING_ARRAY;
    }

    public boolean acceptsProfiles(String ... profiles) {
        Assert.notNull((Object)profiles, (String)"Profiles must not be null");
        return Arrays.stream(profiles).anyMatch(p -> this.environment.getActiveNames().contains(p));
    }

    public boolean acceptsProfiles(@NonNull Profiles profiles) {
        Assert.notNull((Object)profiles, (String)"Profiles must not be null");
        return profiles.matches(this::isProfileActive);
    }

    private boolean isProfileActive(String profile) {
        Set currentActiveProfiles = this.environment.getActiveNames();
        return currentActiveProfiles.contains(profile);
    }

    public boolean containsProperty(String key) {
        return this.environment.containsProperty(key) || this.environment.containsProperties(key);
    }

    @Nullable
    public String getProperty(@NonNull String key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.environment.getProperty(key, String.class).orElse(null);
    }

    @NonNull
    public String getProperty(@NonNull String key, @NonNull String defaultValue) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.environment.getProperty(key, String.class).orElse(defaultValue);
    }

    @Nullable
    public <T> T getProperty(@NonNull String key, @NonNull Class<T> targetType) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(targetType, (String)"Target type must not be null");
        return this.environment.getProperty(key, targetType).orElse(null);
    }

    public <T> T getProperty(@NonNull String key, @NonNull Class<T> targetType, @NonNull T defaultValue) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(targetType, (String)"Target type must not be null");
        return this.environment.getProperty(key, targetType).orElse(defaultValue);
    }

    public String getRequiredProperty(@NonNull String key) throws IllegalStateException {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (String)this.environment.getProperty(key, String.class).orElseThrow(() -> new IllegalStateException("Property with key [" + key + "] not present"));
    }

    public <T> T getRequiredProperty(String key, Class<T> targetType) throws IllegalStateException {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(targetType, (String)"Target type must not be null");
        return this.environment.getProperty(key, targetType).orElseThrow(() -> new IllegalStateException("Property with key [" + key + "] not present"));
    }

    public String resolvePlaceholders(@NonNull String text) {
        return this.environment.getPlaceholderResolver().resolvePlaceholders(text).orElse(text);
    }

    public String resolveRequiredPlaceholders(@NonNull String text) throws IllegalArgumentException {
        return this.environment.getPlaceholderResolver().resolveRequiredPlaceholders(text);
    }

    @NonNull
    public Environment getEnvironment() {
        return this.environment;
    }

    public void setActiveProfiles(String ... profiles) {
        throw new UnsupportedOperationException("Method setActiveProfiles not supported");
    }

    public void addActiveProfile(String profile) {
        throw new UnsupportedOperationException("Method addActiveProfile not supported");
    }

    public void setDefaultProfiles(String ... profiles) {
        throw new UnsupportedOperationException("Method setDefaultProfiles not supported");
    }

    public MutablePropertySources getPropertySources() {
        return new MutablePropertySources();
    }

    public Map<String, Object> getSystemProperties() {
        Collection propertySources = this.environment.getPropertySources();
        Optional<PropertySource> opt = propertySources.stream().filter(ps -> ps instanceof SystemPropertiesPropertySource).findFirst();
        if (opt.isPresent()) {
            SystemPropertiesPropertySource ps2 = (SystemPropertiesPropertySource)opt.get();
            return ps2.asMap();
        }
        return Collections.emptyMap();
    }

    public Map<String, Object> getSystemEnvironment() {
        Collection propertySources = this.environment.getPropertySources();
        Optional<PropertySource> opt = propertySources.stream().filter(ps -> ps instanceof EnvironmentPropertySource).findFirst();
        if (opt.isPresent()) {
            EnvironmentPropertySource ps2 = (EnvironmentPropertySource)opt.get();
            return ps2.asMap();
        }
        return Collections.emptyMap();
    }

    public void merge(ConfigurableEnvironment parent) {
        throw new UnsupportedOperationException("Method parent not supported");
    }

    public ConfigurableConversionService getConversionService() {
        return this.conversionService;
    }

    public void setConversionService(ConfigurableConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        throw new UnsupportedOperationException("Method setPlaceholderPrefix not supported");
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        throw new UnsupportedOperationException("Method setPlaceholderSuffix not supported");
    }

    public void setValueSeparator(String valueSeparator) {
        throw new UnsupportedOperationException("Method setValueSeparator not supported");
    }

    public void setEscapeCharacter(Character escapeCharacter) {
        throw new UnsupportedOperationException("Method setEscapeCharacter not supported");
    }

    public void setIgnoreUnresolvableNestedPlaceholders(boolean ignoreUnresolvableNestedPlaceholders) {
        throw new UnsupportedOperationException("Method setIgnoreUnresolvableNestedPlaceholders not supported");
    }

    public void setRequiredProperties(String ... requiredProperties) {
        this.requiredProperties = requiredProperties;
    }

    public void validateRequiredProperties() throws MissingRequiredPropertiesException {
        if (this.requiredProperties != null) {
            final HashSet<String> missingProps = new HashSet<String>();
            for (String requiredProperty : this.requiredProperties) {
                if (this.environment.containsProperty(requiredProperty)) continue;
                missingProps.add(requiredProperty);
            }
            if (!missingProps.isEmpty()) {
                throw new MissingRequiredPropertiesException(){

                    public Set<String> getMissingRequiredProperties() {
                        return missingProps;
                    }
                };
            }
        }
    }
}

