/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.web.annotation.exchange;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Head;
import io.micronaut.http.annotation.HttpMethodMapping;
import io.micronaut.http.annotation.Options;
import io.micronaut.http.annotation.Patch;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.Put;
import io.micronaut.http.annotation.Trace;
import io.micronaut.http.annotation.UriMapping;
import io.micronaut.inject.annotation.NamedAnnotationTransformer;
import io.micronaut.inject.visitor.VisitorContext;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

public class HttpExchangeAnnotationTransformer
implements NamedAnnotationTransformer {
    public String getName() {
        return "org.springframework.web.service.annotation.HttpExchange";
    }

    protected boolean isHttpMethodMapping(@Nullable String method) {
        return method != null;
    }

    @NonNull
    protected AnnotationValueBuilder<?> newBuilder(String method) {
        if (method != null) {
            return switch (method.toUpperCase()) {
                case "GET" -> AnnotationValue.builder(Get.class);
                case "POST" -> AnnotationValue.builder(Post.class);
                case "PATCH" -> AnnotationValue.builder(Patch.class);
                case "PUT" -> AnnotationValue.builder(Put.class);
                case "DELETE" -> AnnotationValue.builder(Delete.class);
                case "HEAD" -> AnnotationValue.builder(Head.class);
                case "OPTIONS" -> AnnotationValue.builder(Options.class);
                case "TRACE" -> AnnotationValue.builder(Trace.class);
                default -> AnnotationValue.builder(UriMapping.class);
            };
        }
        return AnnotationValue.builder(UriMapping.class);
    }

    private String computePath(AnnotationValue<Annotation> annotation) {
        return annotation.stringValue().orElseGet(() -> annotation.stringValue("url").orElse("/"));
    }

    public List<AnnotationValue<?>> transform(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        Object[] accept;
        ArrayList annotations = new ArrayList();
        String path = this.computePath(annotation);
        String method = annotation.stringValue("method").orElse(null);
        annotations.add(this.newBuilder(method).value(path).build());
        String contentType = annotation.stringValue("contentType").orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)contentType)) {
            annotations.add(AnnotationValue.builder(Consumes.class).member("contentType", contentType).build());
        }
        if (ArrayUtils.isNotEmpty((Object[])(accept = annotation.stringValues("accept")))) {
            annotations.add(AnnotationValue.builder(Produces.class).member("value", (String[])accept).build());
        }
        if (this.isHttpMethodMapping(method)) {
            annotations.add(AnnotationValue.builder(HttpMethodMapping.class).value(path).build());
        }
        return annotations;
    }
}

