/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.web.annotation;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Head;
import io.micronaut.http.annotation.HttpMethodMapping;
import io.micronaut.http.annotation.Options;
import io.micronaut.http.annotation.Patch;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.Put;
import io.micronaut.http.annotation.Trace;
import io.micronaut.inject.annotation.NamedAnnotationTransformer;
import io.micronaut.inject.visitor.VisitorContext;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class RequestMappingAnnotationTransformer
implements NamedAnnotationTransformer {
    public String getName() {
        return "org.springframework.web.bind.annotation.RequestMapping";
    }

    protected boolean isHttpMethodMapping(@Nullable HttpMethod method) {
        return method != null;
    }

    @NonNull
    protected AnnotationValueBuilder<?> newBuilder(@Nullable HttpMethod httpMethod, AnnotationValue<Annotation> annotation) {
        if (httpMethod != null) {
            switch (httpMethod) {
                case TRACE: {
                    return AnnotationValue.builder(Trace.class);
                }
                case DELETE: {
                    return AnnotationValue.builder(Delete.class);
                }
                case GET: {
                    return AnnotationValue.builder(Get.class);
                }
                case HEAD: {
                    return AnnotationValue.builder(Head.class);
                }
                case POST: {
                    return AnnotationValue.builder(Post.class);
                }
                case PUT: {
                    return AnnotationValue.builder(Put.class);
                }
                case PATCH: {
                    return AnnotationValue.builder(Patch.class);
                }
                case OPTIONS: {
                    return AnnotationValue.builder(Options.class);
                }
            }
            return AnnotationValue.builder((String)"io.micronaut.http.annotation.UriMapping");
        }
        return AnnotationValue.builder((String)"io.micronaut.http.annotation.UriMapping");
    }

    private String computePath(AnnotationValue<Annotation> annotation) {
        return annotation.stringValue().orElseGet(() -> annotation.stringValue("path").orElse("/"));
    }

    public List<AnnotationValue<?>> transform(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        ArrayList annotations = new ArrayList();
        String path = this.computePath(annotation);
        Optional method = annotation.enumValue("method", HttpMethod.class);
        annotations.add(this.newBuilder(method.orElse(null), annotation).value(path).build());
        Object[] consumes = annotation.stringValues("consumes");
        Object[] produces = annotation.stringValues("produces");
        if (ArrayUtils.isNotEmpty((Object[])consumes)) {
            annotations.add(AnnotationValue.builder(Consumes.class).member("value", (String[])consumes).build());
        }
        if (ArrayUtils.isNotEmpty((Object[])produces)) {
            annotations.add(AnnotationValue.builder(Produces.class).member("value", (String[])produces).build());
        }
        if (this.isHttpMethodMapping(method.orElse(null))) {
            annotations.add(AnnotationValue.builder(HttpMethodMapping.class).value(path).build());
        }
        return annotations;
    }
}

