/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.web.annotation;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Head;
import io.micronaut.http.annotation.HttpMethodMapping;
import io.micronaut.http.annotation.Options;
import io.micronaut.http.annotation.Patch;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.Put;
import io.micronaut.http.annotation.Trace;
import io.micronaut.inject.annotation.NamedAnnotationTransformer;
import io.micronaut.inject.visitor.VisitorContext;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

public class RequestMappingAnnotationTransformer
implements NamedAnnotationTransformer {
    public String getName() {
        return "org.springframework.web.bind.annotation.RequestMapping";
    }

    protected boolean isHttpMethodMapping(@Nullable HttpMethod method) {
        return method != null;
    }

    @NonNull
    protected AnnotationValueBuilder<?> newBuilder(@Nullable HttpMethod httpMethod, AnnotationValue<Annotation> annotation) {
        if (httpMethod != null) {
            return switch (httpMethod) {
                case HttpMethod.TRACE -> AnnotationValue.builder(Trace.class);
                case HttpMethod.DELETE -> AnnotationValue.builder(Delete.class);
                case HttpMethod.GET -> AnnotationValue.builder(Get.class);
                case HttpMethod.HEAD -> AnnotationValue.builder(Head.class);
                case HttpMethod.POST -> AnnotationValue.builder(Post.class);
                case HttpMethod.PUT -> AnnotationValue.builder(Put.class);
                case HttpMethod.PATCH -> AnnotationValue.builder(Patch.class);
                case HttpMethod.OPTIONS -> AnnotationValue.builder(Options.class);
                default -> AnnotationValue.builder((String)"io.micronaut.http.annotation.UriMapping");
            };
        }
        return AnnotationValue.builder((String)"io.micronaut.http.annotation.UriMapping");
    }

    private String computePath(AnnotationValue<Annotation> annotation) {
        return annotation.stringValue().orElseGet(() -> annotation.stringValue("path").orElse("/"));
    }

    public List<AnnotationValue<?>> transform(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        ArrayList annotations = new ArrayList();
        String path = this.computePath(annotation);
        HttpMethod method = annotation.enumValue("method", HttpMethod.class).orElse(null);
        annotations.add(this.newBuilder(method, annotation).value(path).build());
        Object[] consumes = annotation.stringValues("consumes");
        Object[] produces = annotation.stringValues("produces");
        if (ArrayUtils.isNotEmpty((Object[])consumes)) {
            annotations.add(AnnotationValue.builder(Consumes.class).member("value", (String[])consumes).build());
        }
        if (ArrayUtils.isNotEmpty((Object[])produces)) {
            annotations.add(AnnotationValue.builder(Produces.class).member("value", (String[])produces).build());
        }
        if (this.isHttpMethodMapping(method)) {
            annotations.add(AnnotationValue.builder(HttpMethodMapping.class).value(path).build());
        }
        return annotations;
    }
}

