/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.web.bind;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.AnnotatedRequestArgumentBinder;
import java.util.Optional;
import javax.inject.Singleton;
import org.springframework.web.bind.annotation.RequestAttribute;

@Singleton
@Requires(classes={RequestAttribute.class})
public class RequestAttributeArgumentBinder
implements AnnotatedRequestArgumentBinder<RequestAttribute, Object> {
    public Class<RequestAttribute> getAnnotationType() {
        return RequestAttribute.class;
    }

    public ArgumentBinder.BindingResult<Object> bind(final ArgumentConversionContext<Object> context, final HttpRequest<?> source) {
        AnnotationMetadata annotationMetadata = context.getAnnotationMetadata();
        final boolean required = annotationMetadata.getValue("required", Boolean.TYPE).orElse(true);
        final String name = annotationMetadata.getValue(RequestAttribute.class, String.class).orElseGet(() -> annotationMetadata.getValue(RequestAttribute.class, "name", String.class).orElse(context.getArgument().getName()));
        return new ArgumentBinder.BindingResult<Object>(){

            public Optional<Object> getValue() {
                return source.getAttributes().get((CharSequence)name, context);
            }

            public boolean isSatisfied() {
                return !required;
            }
        };
    }
}

