/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.web.bind;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import jakarta.inject.Singleton;
import java.util.Optional;
import org.springframework.ui.ConcurrentModel;
import org.springframework.ui.Model;

@Requires(classes={Model.class})
@Singleton
@Internal
public class ModelRequestArgumentBinder
implements TypedRequestArgumentBinder<Model> {
    public static final String ATTRIBUTE = "io.micronaut.spring.MODEL";

    public ArgumentBinder.BindingResult<Model> bind(ArgumentConversionContext<Model> context, HttpRequest<?> source) {
        Optional attribute = source.getAttribute((CharSequence)ATTRIBUTE, Model.class);
        if (!attribute.isPresent()) {
            ConcurrentModel concurrentModel = new ConcurrentModel();
            source.setAttribute((CharSequence)ATTRIBUTE, (Object)concurrentModel);
            return () -> Optional.of(concurrentModel);
        }
        return () -> attribute;
    }

    public Argument<Model> argumentType() {
        return Argument.of(Model.class);
    }
}

