/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.web.bind;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import java.util.Optional;
import org.springframework.ui.ModelMap;

public class ModelMapRequestArgumentBinder
implements TypedRequestArgumentBinder<ModelMap> {
    public static final String ATTRIBUTE = "io.micronaut.spring.MODEL_MAP";

    public Argument<ModelMap> argumentType() {
        return Argument.of(ModelMap.class);
    }

    public ArgumentBinder.BindingResult<ModelMap> bind(ArgumentConversionContext<ModelMap> context, HttpRequest<?> source) {
        Optional attribute = source.getAttribute((CharSequence)ATTRIBUTE, ModelMap.class);
        if (!attribute.isPresent()) {
            ModelMap modelMap = new ModelMap();
            source.setAttribute((CharSequence)ATTRIBUTE, (Object)modelMap);
            return () -> Optional.of(modelMap);
        }
        return () -> attribute;
    }
}

