/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.web.bind;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.spring.web.reactive.ChannelResolver;
import io.micronaut.spring.web.reactive.MicronautServerHttpRequest;
import jakarta.inject.Singleton;
import java.util.Optional;
import org.springframework.http.server.reactive.ServerHttpRequest;

@Singleton
@Internal
public class ServerHttpRequestBinder
implements TypedRequestArgumentBinder<ServerHttpRequest> {
    private final ChannelResolver channelResolver;
    private final HttpServerConfiguration serverConfiguration;

    public ServerHttpRequestBinder(ChannelResolver channelResolver, HttpServerConfiguration serverConfiguration) {
        this.channelResolver = channelResolver;
        this.serverConfiguration = serverConfiguration;
    }

    public Argument<ServerHttpRequest> argumentType() {
        return Argument.of(ServerHttpRequest.class);
    }

    public ArgumentBinder.BindingResult<ServerHttpRequest> bind(ArgumentConversionContext<ServerHttpRequest> context, HttpRequest<?> source) {
        return () -> Optional.of(new MicronautServerHttpRequest(source, this.channelResolver, this.serverConfiguration));
    }
}

