/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.web;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.views.ModelAndView;
import io.micronaut.views.ViewsFilter;
import io.micronaut.views.ViewsRenderer;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.springframework.ui.Model;

@Filter(value={"/**"})
@Requirements(value={@Requires(classes={ModelAndView.class, Model.class}), @Requires(beans={ViewsRenderer.class})})
public class ModelAndViewServerFilter
implements HttpServerFilter {
    private final ViewsFilter viewsFilter;

    public ModelAndViewServerFilter(ViewsFilter viewsFilter) {
        this.viewsFilter = viewsFilter;
    }

    public int getOrder() {
        return this.viewsFilter.getOrder() + 10;
    }

    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        Publisher responsePublisher = chain.proceed(request);
        return Publishers.map((Publisher)responsePublisher, mutableHttpResponse -> {
            Optional attribute = request.getAttribute((CharSequence)"io.micronaut.spring.MODEL", Model.class);
            Object body = mutableHttpResponse.body();
            boolean isCharSeq = body instanceof CharSequence;
            if (isCharSeq) {
                if (attribute.isPresent()) {
                    String view = body.toString();
                    Model model = (Model)attribute.get();
                    MutableHttpResponse res = mutableHttpResponse;
                    res.body((Object)new ModelAndView(view, (Object)model.asMap()));
                    return res;
                }
                Optional modelMap = request.getAttribute((CharSequence)"io.micronaut.spring.MODEL");
                if (modelMap.isPresent()) {
                    String view = body.toString();
                    Object o = modelMap.get();
                    if (o instanceof Model) {
                        Model model = (Model)o;
                        MutableHttpResponse res = mutableHttpResponse;
                        res.body((Object)new ModelAndView(view, (Object)model));
                        return res;
                    }
                }
            }
            return mutableHttpResponse;
        });
    }
}

