/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.web;

import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;

@Filter(value={"/**"})
public class ResponseEntityServerFilter
implements HttpServerFilter {
    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        Publisher responsePublisher = chain.proceed(request);
        return Publishers.map((Publisher)responsePublisher, mutableHttpResponse -> {
            Object body = mutableHttpResponse.body();
            if (body instanceof HttpEntity) {
                HttpEntity entity = (HttpEntity)body;
                if (entity instanceof ResponseEntity) {
                    ResponseEntity responseEntity = (ResponseEntity)entity;
                    mutableHttpResponse.status(responseEntity.getStatusCode().value());
                }
                HttpHeaders headers = entity.getHeaders();
                MutableHttpHeaders micronautHeaders = mutableHttpResponse.getHeaders();
                for (Map.Entry entry : headers.entrySet()) {
                    String key = (String)entry.getKey();
                    List value = (List)entry.getValue();
                    for (String v : value) {
                        micronautHeaders.add((CharSequence)key, (CharSequence)v);
                    }
                }
                Object b = entity.getBody();
                if (b != null) {
                    mutableHttpResponse.body(b);
                }
            } else if (body instanceof HttpHeaders) {
                HttpHeaders httpHeaders = (HttpHeaders)body;
                mutableHttpResponse.body(null);
                httpHeaders.forEach((s, strings) -> {
                    MutableHttpHeaders headers = mutableHttpResponse.getHeaders();
                    for (String string : strings) {
                        headers.add((CharSequence)s, (CharSequence)string);
                    }
                });
            }
            return mutableHttpResponse;
        });
    }
}

