/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.web.reactive;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.spring.web.reactive.ChannelResolver;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.ssl.SslHandler;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.SSLSession;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.http.server.reactive.SslInfo;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;

public class MicronautServerHttpRequest
extends AbstractServerHttpRequest {
    private final HttpRequest<?> request;
    private final ChannelResolver channelResolver;
    private final HttpServerConfiguration serverConfiguration;

    public MicronautServerHttpRequest(HttpRequest<?> request, ChannelResolver channelResolver, HttpServerConfiguration serverConfiguration) {
        super(HttpMethod.valueOf((String)request.getMethod().name()), request.getUri(), null, (MultiValueMap)MicronautServerHttpRequest.initHeaders(request));
        this.request = request;
        this.channelResolver = channelResolver;
        this.serverConfiguration = serverConfiguration;
    }

    private static HttpHeaders initHeaders(HttpRequest<?> request) {
        HttpHeaders httpHeaders = new HttpHeaders();
        io.micronaut.http.HttpHeaders micronautHeaders = request.getHeaders();
        micronautHeaders.forEach(entry -> {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            httpHeaders.addAll(key, value);
        });
        return httpHeaders;
    }

    protected MultiValueMap<String, HttpCookie> initCookies() {
        Cookies cookies = this.request.getCookies();
        LinkedMultiValueMap cookieMultiValueMap = new LinkedMultiValueMap();
        cookies.forEach((arg_0, arg_1) -> MicronautServerHttpRequest.lambda$initCookies$1((MultiValueMap)cookieMultiValueMap, arg_0, arg_1));
        return cookieMultiValueMap;
    }

    protected SslInfo initSslInfo() {
        SslHandler sslHandler;
        Optional<Channel> channel = this.channelResolver.resolveChannel(this.request);
        if (channel.isPresent() && (sslHandler = (SslHandler)channel.get().pipeline().get(SslHandler.class)) != null) {
            SSLSession session = sslHandler.engine().getSession();
            return new DefaultSslInfo(session);
        }
        return null;
    }

    public <T> T getNativeRequest() {
        return (T)this.request;
    }

    public HttpMethod getMethod() {
        return HttpMethod.valueOf((String)this.request.getMethod().name());
    }

    public Flux<DataBuffer> getBody() {
        Optional<Channel> opt = this.channelResolver.resolveChannel(this.request);
        if (opt.isPresent()) {
            Channel channel = opt.get();
            NettyDataBufferFactory nettyDataBufferFactory = new NettyDataBufferFactory(channel.alloc());
            NettyHttpRequest nettyRequest = (NettyHttpRequest)this.request;
            try {
                return Flux.from((Publisher)nettyRequest.rootBody().rawContent(this.serverConfiguration).asPublisher()).map(b -> nettyDataBufferFactory.wrap((ByteBuf)b));
            }
            catch (Throwable e) {
                return Flux.error((Throwable)e);
            }
        }
        return Flux.empty();
    }

    private static /* synthetic */ void lambda$initCookies$1(MultiValueMap cookieMultiValueMap, String s, Cookie cookie) {
        HttpCookie httpCookie = new HttpCookie(cookie.getName(), cookie.getValue());
        cookieMultiValueMap.set((Object)s, (Object)httpCookie);
    }

    final class DefaultSslInfo
    implements SslInfo {
        @Nullable
        private final String sessionId;
        @Nullable
        private final X509Certificate[] peerCertificates;

        DefaultSslInfo(SSLSession session) {
            Assert.notNull((Object)session, (String)"SSLSession is required");
            this.sessionId = this.initSessionId(session);
            this.peerCertificates = this.initCertificates(session);
        }

        @Nullable
        public String getSessionId() {
            return this.sessionId;
        }

        @Nullable
        public X509Certificate[] getPeerCertificates() {
            return this.peerCertificates;
        }

        @Nullable
        private String initSessionId(SSLSession session) {
            byte[] bytes = session.getId();
            if (bytes == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (byte b : bytes) {
                String digit = Integer.toHexString(b);
                if (digit.length() < 2) {
                    sb.append('0');
                }
                if (digit.length() > 2) {
                    digit = digit.substring(digit.length() - 2);
                }
                sb.append(digit);
            }
            return sb.toString();
        }

        @Nullable
        private X509Certificate[] initCertificates(SSLSession session) {
            Certificate[] certificates;
            try {
                certificates = session.getPeerCertificates();
            }
            catch (Throwable ex) {
                return null;
            }
            ArrayList<X509Certificate> result = new ArrayList<X509Certificate>(certificates.length);
            for (Certificate certificate : certificates) {
                if (!(certificate instanceof X509Certificate)) continue;
                result.add((X509Certificate)certificate);
            }
            return !result.isEmpty() ? result.toArray(new X509Certificate[0]) : null;
        }
    }
}

