/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.tx.annotation;

import io.micronaut.aop.InterceptPhase;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.spring.tx.annotation.BindableRuleBasedTransactionAttribute;
import io.micronaut.spring.tx.annotation.Transactional;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.interceptor.TransactionAttribute;

@Singleton
public class TransactionInterceptor
extends TransactionAspectSupport
implements MethodInterceptor<Object, Object> {
    private final Map<ExecutableMethod, TransactionAttribute> transactionDefinitionMap = new ConcurrentHashMap<ExecutableMethod, TransactionAttribute>();
    private final Map<String, PlatformTransactionManager> transactionManagerMap = new ConcurrentHashMap<String, PlatformTransactionManager>();
    private final BeanLocator beanLocator;

    public TransactionInterceptor(BeanLocator beanLocator) {
        this.beanLocator = beanLocator;
    }

    public int getOrder() {
        return InterceptPhase.TRANSACTION.getPosition();
    }

    public final Object intercept(MethodInvocationContext<Object, Object> context) {
        if (context.hasStereotype(Transactional.class)) {
            Object retVal;
            String transactionManagerName = context.stringValue(Transactional.class).orElse(null);
            if (StringUtils.isEmpty((CharSequence)transactionManagerName)) {
                transactionManagerName = null;
            }
            PlatformTransactionManager transactionManager = this.resolveTransactionManager(transactionManagerName);
            String finalTransactionManagerName = transactionManagerName;
            TransactionAttribute transactionDefinition = this.resolveTransactionAttribute((ExecutableMethod<Object, Object>)context.getExecutableMethod(), (AnnotationMetadata)context, finalTransactionManagerName);
            TransactionAspectSupport.TransactionInfo transactionInfo = this.createTransactionIfNecessary(transactionManager, transactionDefinition, context.getDeclaringType().getName() + "." + context.getMethodName());
            try {
                retVal = context.proceed();
            }
            catch (Throwable ex) {
                this.completeTransactionAfterThrowing(transactionInfo, ex);
                throw ex;
            }
            finally {
                this.cleanupTransactionInfo(transactionInfo);
            }
            this.commitTransactionAfterReturning(transactionInfo);
            return retVal;
        }
        return context.proceed();
    }

    public void afterPropertiesSet() {
    }

    protected TransactionAttribute resolveTransactionAttribute(ExecutableMethod<Object, Object> targetMethod, AnnotationMetadata annotationMetadata, String transactionManagerName) {
        return this.transactionDefinitionMap.computeIfAbsent(targetMethod, method -> {
            BindableRuleBasedTransactionAttribute attribute = new BindableRuleBasedTransactionAttribute();
            attribute.setReadOnly(annotationMetadata.isTrue(Transactional.class, "readOnly"));
            attribute.setTimeout(annotationMetadata.intValue(Transactional.class, "timeout").orElse(-1));
            attribute.setRollbackFor(annotationMetadata.classValues(Transactional.class, "rollbackFor"));
            attribute.setNoRollbackFor(annotationMetadata.classValues(Transactional.class, "noRollbackFor"));
            int propagation = annotationMetadata.enumValue(Transactional.class, "propagation", Propagation.class).orElse(Propagation.REQUIRED).value();
            attribute.setPropagationBehavior(propagation);
            int isolation = annotationMetadata.enumValue(Transactional.class, "isolation", Isolation.class).orElse(Isolation.DEFAULT).value();
            attribute.setIsolationLevel(isolation);
            attribute.setQualifier(transactionManagerName);
            return attribute;
        });
    }

    private PlatformTransactionManager resolveTransactionManager(String transactionManagerName) {
        try {
            if (transactionManagerName != null) {
                return this.transactionManagerMap.computeIfAbsent(transactionManagerName, s -> (PlatformTransactionManager)this.beanLocator.getBean(PlatformTransactionManager.class, Qualifiers.byName((String)transactionManagerName)));
            }
            return this.transactionManagerMap.computeIfAbsent("default", s -> (PlatformTransactionManager)this.beanLocator.getBean(PlatformTransactionManager.class));
        }
        catch (NoSuchBeanException e) {
            throw new TransactionSystemException("No transaction manager configured" + (transactionManagerName != null ? " for name: " + transactionManagerName : ""));
        }
    }
}

