/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.core.annotation;

import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.CollectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.MergedAnnotation;

@Internal
class MergedAnnotationValue<A extends Annotation>
implements MergedAnnotation<A> {
    private final AnnotationMetadata annotationMetadata;
    private final AnnotationValue<A> value;

    public MergedAnnotationValue(AnnotationMetadata annotationMetadata, AnnotationValue<A> value) {
        this.annotationMetadata = annotationMetadata;
        this.value = value;
    }

    public Class<A> getType() {
        return this.annotationMetadata.getAnnotationType(this.value.getAnnotationName()).orElseGet(() -> (Class)ClassUtils.forName((String)this.value.getAnnotationName(), (ClassLoader)this.getClass().getClassLoader()).orElseThrow(() -> new IllegalStateException("Annotation class not present")));
    }

    public boolean isPresent() {
        return true;
    }

    public boolean isDirectlyPresent() {
        return this.annotationMetadata.hasDeclaredAnnotation(this.value.getAnnotationName());
    }

    public boolean isMetaPresent() {
        return this.annotationMetadata.hasStereotype(this.value.getAnnotationName()) && !this.annotationMetadata.hasAnnotation(this.value.getAnnotationName());
    }

    public int getDistance() {
        return this.isMetaPresent() ? 1 : 0;
    }

    public int getAggregateIndex() {
        return 0;
    }

    public Object getSource() {
        return null;
    }

    public MergedAnnotation<?> getMetaSource() {
        AnnotationValue av;
        String metaAnnotationName;
        if (this.isMetaPresent() && (metaAnnotationName = (String)this.annotationMetadata.getAnnotationNameByStereotype(this.value.getAnnotationName()).orElse(null)) != null && (av = this.annotationMetadata.getAnnotation(metaAnnotationName)) != null) {
            return new MergedAnnotationValue<A>(this.annotationMetadata, av);
        }
        return null;
    }

    public MergedAnnotation<?> getRoot() {
        if (this.isMetaPresent()) {
            AnnotationValue av;
            String next;
            String metaAnnotationName = this.annotationMetadata.getAnnotationNameByStereotype(this.value.getAnnotationName()).orElse(null);
            while (metaAnnotationName != null && (next = (String)this.annotationMetadata.getAnnotationNameByStereotype(metaAnnotationName).orElse(null)) != null) {
                metaAnnotationName = next;
            }
            if (metaAnnotationName != null && (av = this.annotationMetadata.getAnnotation(metaAnnotationName)) != null) {
                return new MergedAnnotationValue<A>(this.annotationMetadata, av);
            }
        }
        return this;
    }

    public List<Class<? extends Annotation>> getMetaTypes() {
        if (this.isMetaPresent()) {
            ArrayList<Class<A>> metaTypes = new ArrayList<Class<A>>();
            List annotationTypes = this.annotationMetadata.getAnnotationTypesByStereotype(this.value.getAnnotationName());
            metaTypes.add(this.getType());
            metaTypes.addAll(annotationTypes);
            return Collections.unmodifiableList(metaTypes);
        }
        return Collections.singletonList(this.getType());
    }

    public boolean hasNonDefaultValue(String attributeName) {
        return this.value.contains(attributeName);
    }

    public boolean hasDefaultValue(String attributeName) throws NoSuchElementException {
        return !this.value.contains(attributeName) && this.annotationMetadata.getDefaultValue(this.value.getAnnotationName(), attributeName, Object.class).isPresent();
    }

    public byte getByte(String attributeName) throws NoSuchElementException {
        return this.value.byteValue(attributeName).orElseGet(() -> (Byte)this.value.get((CharSequence)attributeName, Byte.class).orElseThrow(this.missingHandler(attributeName)));
    }

    private Supplier<NoSuchElementException> missingHandler(String attributeName) {
        return () -> new NoSuchElementException("Annotation [" + this.value.getAnnotationName() + "] attribute [" + attributeName + "] does not exist");
    }

    public byte[] getByteArray(String attributeName) throws NoSuchElementException {
        return this.value.byteValues(attributeName);
    }

    public boolean getBoolean(String attributeName) throws NoSuchElementException {
        return this.value.booleanValue(attributeName).orElseGet(() -> (Boolean)this.value.get((CharSequence)attributeName, Boolean.class).orElseThrow(this.missingHandler(attributeName)));
    }

    public boolean[] getBooleanArray(String attributeName) throws NoSuchElementException {
        return this.value.booleanValues(attributeName);
    }

    public char getChar(String attributeName) throws NoSuchElementException {
        return this.value.charValue(attributeName).orElseGet(() -> (Character)this.value.get((CharSequence)attributeName, Character.class).orElseThrow(this.missingHandler(attributeName))).charValue();
    }

    public char[] getCharArray(String attributeName) throws NoSuchElementException {
        return this.value.charValues(attributeName);
    }

    public short getShort(String attributeName) throws NoSuchElementException {
        return this.value.shortValue(attributeName).orElseGet(() -> (Short)this.value.get((CharSequence)attributeName, Short.class).orElseThrow(this.missingHandler(attributeName)));
    }

    public short[] getShortArray(String attributeName) throws NoSuchElementException {
        return this.value.shortValues(attributeName);
    }

    public int getInt(String attributeName) throws NoSuchElementException {
        return this.value.intValue(attributeName).orElseGet(() -> (Integer)this.value.get((CharSequence)attributeName, Integer.class).orElseThrow(this.missingHandler(attributeName)));
    }

    public int[] getIntArray(String attributeName) throws NoSuchElementException {
        return this.value.intValues(attributeName);
    }

    public long getLong(String attributeName) throws NoSuchElementException {
        return this.value.longValue(attributeName).orElseGet(() -> (Long)this.value.get((CharSequence)attributeName, Long.class).orElseThrow(this.missingHandler(attributeName)));
    }

    public long[] getLongArray(String attributeName) throws NoSuchElementException {
        return this.value.longValues(attributeName);
    }

    public double getDouble(String attributeName) throws NoSuchElementException {
        return this.value.doubleValue(attributeName).orElseGet(() -> (Double)this.value.get((CharSequence)attributeName, Double.class).orElseThrow(this.missingHandler(attributeName)));
    }

    public double[] getDoubleArray(String attributeName) throws NoSuchElementException {
        return this.value.doubleValues(attributeName);
    }

    public float getFloat(String attributeName) throws NoSuchElementException {
        return this.value.floatValue(attributeName).orElseGet(() -> (Float)this.value.get((CharSequence)attributeName, Float.class).orElseThrow(this.missingHandler(attributeName))).floatValue();
    }

    public float[] getFloatArray(String attributeName) throws NoSuchElementException {
        return this.value.floatValues(attributeName);
    }

    public String getString(String attributeName) throws NoSuchElementException {
        return this.value.stringValue(attributeName).orElseGet(() -> (String)this.value.get((CharSequence)attributeName, String.class).orElseThrow(this.missingHandler(attributeName)));
    }

    public String[] getStringArray(String attributeName) throws NoSuchElementException {
        return this.value.stringValues(attributeName);
    }

    public Class<?> getClass(String attributeName) throws NoSuchElementException {
        return this.value.classValue(attributeName).orElseGet(() -> (Class)this.value.get((CharSequence)attributeName, Class.class).orElseThrow(this.missingHandler(attributeName)));
    }

    public Class<?>[] getClassArray(String attributeName) throws NoSuchElementException {
        return this.value.classValues(attributeName);
    }

    public <E extends Enum<E>> E getEnum(String attributeName, Class<E> type) throws NoSuchElementException {
        return (E)this.value.enumValue(attributeName, type).orElseGet(() -> (Enum)this.value.get((CharSequence)attributeName, type).orElseThrow(this.missingHandler(attributeName)));
    }

    public <E extends Enum<E>> E[] getEnumArray(String attributeName, Class<E> type) throws NoSuchElementException {
        return this.value.enumValues(attributeName, type);
    }

    public <T extends Annotation> MergedAnnotation<T> getAnnotation(String attributeName, Class<T> type) throws NoSuchElementException {
        return this.value.getAnnotation(attributeName, type).map(av -> new MergedAnnotationValue<A>(this.annotationMetadata, av)).orElseThrow(this.missingHandler(attributeName));
    }

    public <T extends Annotation> MergedAnnotation<T>[] getAnnotationArray(String attributeName, Class<T> type) throws NoSuchElementException {
        return (MergedAnnotation[])this.value.getAnnotations(attributeName, type).stream().map(av -> new MergedAnnotationValue<A>(this.annotationMetadata, av)).toArray(MergedAnnotation[]::new);
    }

    public Optional<Object> getValue(String attributeName) {
        return this.value.get((CharSequence)attributeName, Object.class);
    }

    public <T> Optional<T> getValue(String attributeName, Class<T> type) {
        return this.value.get((CharSequence)attributeName, type);
    }

    public Optional<Object> getDefaultValue(String attributeName) {
        return this.annotationMetadata.getDefaultValue(this.value.getAnnotationName(), attributeName, Object.class);
    }

    public <T> Optional<T> getDefaultValue(String attributeName, Class<T> type) {
        return this.annotationMetadata.getDefaultValue(this.value.getAnnotationName(), attributeName, type);
    }

    public MergedAnnotation<A> filterDefaultValues() {
        return new MergedAnnotationValue<A>(this.annotationMetadata, new AnnotationValue(this.value.getAnnotationName(), this.value.getValues())){

            @Override
            public boolean hasDefaultValue(String attributeName) throws NoSuchElementException {
                return false;
            }

            @Override
            public Optional<Object> getDefaultValue(String attributeName) {
                return Optional.empty();
            }

            @Override
            public <T> Optional<T> getDefaultValue(String attributeName, Class<T> type) {
                return Optional.empty();
            }
        };
    }

    public MergedAnnotation<A> filterAttributes(Predicate<String> predicate) {
        return null;
    }

    public MergedAnnotation<A> withNonMergedAttributes() {
        return this;
    }

    public AnnotationAttributes asAnnotationAttributes(MergedAnnotation.Adapt ... adaptations) {
        return this.asMap((MergedAnnotation<?> mergedAnnotation) -> new AnnotationAttributes(this.value.getAnnotationName(), this.getClass().getClassLoader()), adaptations);
    }

    public Map<String, Object> asMap(MergedAnnotation.Adapt ... adaptations) {
        return this.asMap((MergedAnnotation<?> mergedAnnotation) -> new LinkedHashMap(), adaptations);
    }

    public <T extends Map<String, Object>> T asMap(Function<MergedAnnotation<?>, T> factory, MergedAnnotation.Adapt ... adaptations) {
        return this.asMap(factory, this.value, adaptations);
    }

    private <T extends Map<String, Object>> T asMap(Function<MergedAnnotation<?>, T> factory, AnnotationValue<?> thisValue, MergedAnnotation.Adapt[] adaptations) {
        Map values = thisValue.getValues();
        Map newMap = (Map)factory.apply(this);
        Map<String, Class<Enum>> enumMembers = this.computeEnumMembers(thisValue);
        Set adapts = CollectionUtils.setOf((Object[])adaptations);
        values.forEach((attribute, v) -> {
            v = this.convertValue(factory, adaptations, adapts, v, (Class)enumMembers.get(attribute));
            newMap.put(attribute.toString(), v);
        });
        Map defaultValues = this.annotationMetadata.getDefaultValues(thisValue.getAnnotationName());
        defaultValues.forEach((key, v) -> {
            v = this.convertValue(factory, adaptations, adapts, v, (Class)enumMembers.get(key));
            newMap.putIfAbsent(key, v);
        });
        return (T)newMap;
    }

    private Map<String, Class<? extends Enum>> computeEnumMembers(AnnotationValue<?> thisValue) {
        Class t = this.annotationMetadata.getAnnotationType(thisValue.getAnnotationName()).orElse(null);
        if (t != null) {
            Method[] declaredMethods;
            HashMap result = new HashMap(5);
            for (Method declaredMethod : declaredMethods = t.getDeclaredMethods()) {
                Class<?> rt = declaredMethod.getReturnType();
                if (!Enum.class.isAssignableFrom(rt)) continue;
                result.put(declaredMethod.getName(), rt);
            }
            return Collections.unmodifiableMap(result);
        }
        return Collections.emptyMap();
    }

    private <T extends Map<String, Object>> Object convertValue(Function<MergedAnnotation<?>, T> factory, MergedAnnotation.Adapt[] adaptations, Set<MergedAnnotation.Adapt> adapts, Object value, Class<? extends Enum> aClass) {
        if (aClass != null && value instanceof String) {
            return Enum.valueOf(aClass, value.toString());
        }
        if (value instanceof AnnotationClassValue) {
            AnnotationClassValue acv = (AnnotationClassValue)value;
            value = adapts.contains(MergedAnnotation.Adapt.CLASS_TO_STRING) ? acv.getName() : acv.getType().orElse(null);
        } else if (value instanceof AnnotationValue) {
            AnnotationValue av = (AnnotationValue)value;
            if (adapts.contains(MergedAnnotation.Adapt.ANNOTATION_TO_MAP)) {
                value = this.asMap(factory, av, adaptations);
            }
        }
        return value;
    }

    public A synthesize() throws NoSuchElementException {
        return (A)this.annotationMetadata.synthesize(this.getType());
    }

    public Optional<A> synthesize(Predicate<? super MergedAnnotation<A>> condition) throws NoSuchElementException {
        if (condition != null && condition.test(this)) {
            return Optional.ofNullable(this.synthesize());
        }
        return Optional.empty();
    }
}

