/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.beans;

import io.micronaut.context.DefaultApplicationContext;
import io.micronaut.context.exceptions.BeanInstantiationException;
import java.util.Optional;
import org.springframework.beans.factory.FactoryBean;

class MicronautSpringBeanFactory
implements FactoryBean {
    private Class micronautBeanType;
    private DefaultApplicationContext micronautContext;
    private boolean isMicronautSingleton;

    MicronautSpringBeanFactory() {
    }

    public void setMicronautBeanType(Class micronautBeanType) {
        this.micronautBeanType = micronautBeanType;
    }

    public void setMicronautContext(DefaultApplicationContext micronautContext) {
        this.micronautContext = micronautContext;
    }

    public void setMicronautSingleton(boolean isMicronautSingleton) {
        this.isMicronautSingleton = isMicronautSingleton;
    }

    public Object getObject() throws Exception {
        Optional bean = this.micronautContext.findBean(this.micronautBeanType);
        if (bean.isPresent()) {
            return bean.get();
        }
        throw new BeanInstantiationException("Could Not Create Bean [" + String.valueOf(this.micronautBeanType) + "]");
    }

    public Class<?> getObjectType() {
        return this.micronautBeanType;
    }

    public boolean isSingleton() {
        return this.isMicronautSingleton;
    }
}

