/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.hibernate.jpa;

import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ExecutableMethod;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

@Internal
@Prototype
class TransactionalSessionInterceptor
implements MethodInterceptor<Session, Object> {
    private final SessionFactory sessionFactory;

    @Internal
    TransactionalSessionInterceptor(BeanContext beanContext, Qualifier<SessionFactory> qualifier) {
        this.sessionFactory = (SessionFactory)beanContext.getBean(SessionFactory.class, qualifier);
    }

    public Object intercept(MethodInvocationContext<Session, Object> context) {
        ExecutableMethod method = context.getExecutableMethod();
        return method.invoke((Object)this.sessionFactory.getCurrentSession(), context.getParameterValues());
    }
}

