/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.hibernate.jpa;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.env.Environment;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.convert.format.MapFormat;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.Toggleable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.persistence.Entity;
import javax.validation.ValidatorFactory;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.integrator.spi.Integrator;

@EachProperty(value="jpa", primary="default")
public class JpaConfiguration {
    public static final String PREFIX = "jpa";
    private final BootstrapServiceRegistry bootstrapServiceRegistry;
    private final Environment environment;
    private final ApplicationContext applicationContext;
    private Map<String, Object> jpaProperties = new HashMap<String, Object>(10);
    private List<String> mappingResources = new ArrayList<String>();
    private EntityScanConfiguration entityScanConfiguration;

    protected JpaConfiguration(ApplicationContext applicationContext, @Nullable Integrator integrator) {
        this(applicationContext, integrator, new EntityScanConfiguration(applicationContext.getEnvironment()));
    }

    @Inject
    protected JpaConfiguration(ApplicationContext applicationContext, @Nullable Integrator integrator, @Nullable EntityScanConfiguration entityScanConfiguration) {
        ClassLoader classLoader = applicationContext.getClassLoader();
        BootstrapServiceRegistryBuilder bootstrapServiceRegistryBuilder = this.createBootstrapServiceRegistryBuilder(integrator, classLoader);
        this.bootstrapServiceRegistry = bootstrapServiceRegistryBuilder.build();
        this.entityScanConfiguration = entityScanConfiguration != null ? entityScanConfiguration : new EntityScanConfiguration(applicationContext.getEnvironment());
        this.environment = applicationContext.getEnvironment();
        this.applicationContext = applicationContext;
    }

    public EntityScanConfiguration getEntityScanConfiguration() {
        return this.entityScanConfiguration;
    }

    public StandardServiceRegistry buildStandardServiceRegistry(@Nullable Map<String, Object> additionalSettings) {
        StandardServiceRegistryBuilder standardServiceRegistryBuilder = this.createStandServiceRegistryBuilder(this.bootstrapServiceRegistry);
        Map<String, Object> jpaProperties = this.getProperties();
        if (CollectionUtils.isNotEmpty(jpaProperties)) {
            standardServiceRegistryBuilder.applySettings(jpaProperties);
        }
        if (additionalSettings != null) {
            standardServiceRegistryBuilder.applySettings(additionalSettings);
        }
        return standardServiceRegistryBuilder.build();
    }

    public void setPackagesToScan(String ... packagesToScan) {
        if (ArrayUtils.isNotEmpty((Object[])packagesToScan)) {
            EntityScanConfiguration entityScanConfiguration = new EntityScanConfiguration(this.environment);
            entityScanConfiguration.setClasspath(true);
            entityScanConfiguration.setPackages(packagesToScan);
            this.entityScanConfiguration = entityScanConfiguration;
        }
    }

    public String[] getPackagesToScan() {
        return this.entityScanConfiguration.getPackages();
    }

    public final void setProperties(@MapFormat(transformation=MapFormat.MapTransformation.FLAT, keyFormat=StringConvention.RAW) Map<String, Object> jpaProperties) {
        this.jpaProperties = jpaProperties;
    }

    public Map<String, Object> getProperties() {
        ValidatorFactory validatorFactory = this.applicationContext.containsBean(ValidatorFactory.class) ? (ValidatorFactory)this.applicationContext.getBean(ValidatorFactory.class) : null;
        if (validatorFactory != null) {
            this.jpaProperties.put("javax.persistence.validation.factory", validatorFactory);
        }
        return this.jpaProperties;
    }

    protected BootstrapServiceRegistryBuilder createBootstrapServiceRegistryBuilder(@Nullable Integrator integrator, ClassLoader classLoader) {
        BootstrapServiceRegistryBuilder bootstrapServiceRegistryBuilder = new BootstrapServiceRegistryBuilder();
        bootstrapServiceRegistryBuilder.applyClassLoader(classLoader);
        if (integrator != null) {
            bootstrapServiceRegistryBuilder.applyIntegrator(integrator);
        }
        return bootstrapServiceRegistryBuilder;
    }

    protected StandardServiceRegistryBuilder createStandServiceRegistryBuilder(BootstrapServiceRegistry bootstrapServiceRegistry) {
        return new StandardServiceRegistryBuilder(bootstrapServiceRegistry);
    }

    public List<String> getMappingResources() {
        return this.mappingResources;
    }

    public void setMappingResources(List<String> mappingResources) {
        this.mappingResources = mappingResources;
    }

    @ConfigurationProperties(value="entity-scan")
    public static class EntityScanConfiguration
    implements Toggleable {
        private boolean enabled = true;
        private boolean classpath = false;
        private String[] packages = StringUtils.EMPTY_STRING_ARRAY;
        private final Environment environment;

        public EntityScanConfiguration(Environment environment) {
            this.environment = environment;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isClasspath() {
            return this.classpath;
        }

        public void setClasspath(boolean classpath) {
            this.classpath = classpath;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String[] getPackages() {
            return this.packages;
        }

        public void setPackages(String[] packages) {
            this.packages = packages;
        }

        public Collection<Class<?>> findEntities() {
            HashSet entities = new HashSet();
            if (this.isClasspath()) {
                if (ArrayUtils.isNotEmpty((Object[])this.packages)) {
                    this.environment.scan(Entity.class, this.packages).forEach(entities::add);
                } else {
                    this.environment.scan(Entity.class).forEach(entities::add);
                }
            }
            if (this.isEnabled()) {
                Collection introspections = ArrayUtils.isNotEmpty((Object[])this.packages) ? BeanIntrospector.SHARED.findIntrospections(Entity.class, this.packages) : BeanIntrospector.SHARED.findIntrospections(Entity.class);
                introspections.stream().map(BeanIntrospection::getBeanType).forEach(entities::add);
            }
            return Collections.unmodifiableCollection(entities);
        }
    }
}

