/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.hibernate.jpa;

import io.micronaut.configuration.hibernate.jpa.HibernateCurrentSessionContextClassProvider;
import io.micronaut.configuration.hibernate.jpa.JpaConfiguration;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.jdbc.DataSourceResolver;
import io.micronaut.transaction.hibernate5.MicronautSessionContext;
import java.util.LinkedHashMap;
import javax.sql.DataSource;
import javax.validation.ValidatorFactory;
import org.hibernate.Interceptor;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.mapping.MetadataSource;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.resource.beans.container.spi.ContainedBean;
import org.hibernate.resource.beans.spi.BeanInstanceProducer;
import org.hibernate.service.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
public class EntityManagerFactoryBean {
    private static final Logger LOG = LoggerFactory.getLogger(EntityManagerFactoryBean.class);
    private final ApplicationContext applicationContext;
    private final JpaConfiguration jpaConfiguration;

    public EntityManagerFactoryBean(@Primary @Nullable JpaConfiguration jpaConfiguration, @Primary @Nullable Integrator integrator, ApplicationContext applicationContext) {
        this.jpaConfiguration = jpaConfiguration != null ? jpaConfiguration : new JpaConfiguration(applicationContext, integrator);
        this.applicationContext = applicationContext;
    }

    @EachBean(value=DataSource.class)
    protected StandardServiceRegistry hibernateStandardServiceRegistry(@Parameter String dataSourceName, DataSource dataSource) {
        DataSourceResolver dataSourceResolver = this.applicationContext.findBean(DataSourceResolver.class).orElse(null);
        if (dataSourceResolver != null) {
            dataSource = dataSourceResolver.resolve(dataSource);
        }
        LinkedHashMap<String, Object> additionalSettings = new LinkedHashMap<String, Object>();
        additionalSettings.put("hibernate.connection.datasource", dataSource);
        additionalSettings.put("hibernate.current_session_context_class", this.applicationContext.findBean(HibernateCurrentSessionContextClassProvider.class).map(provider -> provider.get().getName()).orElseGet(MicronautSessionContext.class::getName));
        additionalSettings.put("hibernate.session_factory_name", dataSourceName);
        additionalSettings.put("hibernate.session_factory_name_is_jndi", false);
        additionalSettings.put("hibernate.resource.beans.container", new BeanContainer(){

            public <B> ContainedBean<B> getBean(Class<B> beanType, BeanContainer.LifecycleOptions lifecycleOptions, BeanInstanceProducer fallbackProducer) {
                Object bean = EntityManagerFactoryBean.this.applicationContext.findBean(beanType).orElseGet(() -> fallbackProducer.produceBeanInstance(beanType));
                return () -> bean;
            }

            public <B> ContainedBean<B> getBean(String name, Class<B> beanType, BeanContainer.LifecycleOptions lifecycleOptions, BeanInstanceProducer fallbackProducer) {
                Object bean = EntityManagerFactoryBean.this.applicationContext.findBean(beanType, Qualifiers.byName((String)name)).orElseGet(() -> fallbackProducer.produceBeanInstance(name, beanType));
                return () -> bean;
            }

            public void stop() {
            }
        });
        JpaConfiguration jpaConfiguration = this.applicationContext.findBean(JpaConfiguration.class, Qualifiers.byName((String)dataSourceName)).orElse(this.jpaConfiguration);
        return jpaConfiguration.buildStandardServiceRegistry(additionalSettings);
    }

    @Requires(classes={MetadataSource.class})
    @EachBean(value=StandardServiceRegistry.class)
    protected MetadataSources hibernateMetadataSources(@Parameter @Nullable JpaConfiguration jpaConfiguration, StandardServiceRegistry standardServiceRegistry) {
        if (jpaConfiguration == null) {
            jpaConfiguration = this.jpaConfiguration;
        }
        MetadataSources metadataSources = this.createMetadataSources(standardServiceRegistry);
        jpaConfiguration.getEntityScanConfiguration().findEntities().forEach(arg_0 -> ((MetadataSources)metadataSources).addAnnotatedClass(arg_0));
        if (jpaConfiguration.getMappingResources() != null) {
            for (String resource : jpaConfiguration.getMappingResources()) {
                metadataSources.addResource(resource);
            }
        }
        if (metadataSources.getAnnotatedClasses().isEmpty()) {
            Object[] packages = jpaConfiguration.getEntityScanConfiguration().getPackages();
            if (ArrayUtils.isEmpty((Object[])packages)) {
                packages = this.applicationContext.getEnvironment().getPackages().toArray(StringUtils.EMPTY_STRING_ARRAY);
            }
            throw new ConfigurationException("Entities not found for JPA configuration: '" + jpaConfiguration.getName() + "' within packages [" + String.join((CharSequence)",", (CharSequence[])packages) + "]. Check that you have correctly specified a package containing JPA entities within the \"jpa." + jpaConfiguration.getName() + ".entity-scan.packages\" property in your application configuration and that those entities are either compiled with Micronaut or a build time index produced with @Introspected(packages=\"foo.bar\", includedAnnotations=Entity.class) declared on your Application class");
        }
        return metadataSources;
    }

    @EachBean(value=MetadataSources.class)
    @Requires(beans={MetadataSources.class})
    protected SessionFactoryBuilder hibernateSessionFactoryBuilder(MetadataSources metadataSources, @Nullable ValidatorFactory validatorFactory, @Nullable Interceptor hibernateInterceptor) {
        try {
            Metadata metadata = metadataSources.buildMetadata();
            SessionFactoryBuilder sessionFactoryBuilder = metadata.getSessionFactoryBuilder();
            if (validatorFactory != null) {
                sessionFactoryBuilder.applyValidatorFactory((Object)validatorFactory);
            }
            if (hibernateInterceptor != null) {
                sessionFactoryBuilder.applyInterceptor(hibernateInterceptor);
            }
            return sessionFactoryBuilder;
        }
        catch (MappingException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Hibernate mapping error", (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Error creating SessionFactoryBuilder", (Throwable)e);
            }
            throw e;
        }
    }

    @Context
    @Requires(beans={SessionFactoryBuilder.class})
    @Bean(preDestroy="close")
    @EachBean(value=SessionFactoryBuilder.class)
    protected SessionFactory hibernateSessionFactory(SessionFactoryBuilder sessionFactoryBuilder) {
        return sessionFactoryBuilder.build();
    }

    protected MetadataSources createMetadataSources(@NonNull StandardServiceRegistry serviceRegistry) {
        return new MetadataSources((ServiceRegistry)serviceRegistry);
    }
}

