/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.hibernate.jpa.graal;

import com.oracle.svm.core.annotate.AutomaticFeature;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.graal.AutomaticFeatureUtils;
import org.graalvm.nativeimage.hosted.Feature;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.MariaDB102Dialect;
import org.hibernate.dialect.MariaDB103Dialect;
import org.hibernate.dialect.MariaDB10Dialect;
import org.hibernate.dialect.MariaDB53Dialect;
import org.hibernate.dialect.MariaDBDialect;
import org.hibernate.dialect.MySQL55Dialect;
import org.hibernate.dialect.MySQL57Dialect;
import org.hibernate.dialect.MySQL5Dialect;
import org.hibernate.dialect.MySQL8Dialect;
import org.hibernate.dialect.Oracle10gDialect;
import org.hibernate.dialect.Oracle12cDialect;
import org.hibernate.dialect.Oracle8iDialect;
import org.hibernate.dialect.Oracle9iDialect;
import org.hibernate.dialect.PostgreSQL10Dialect;
import org.hibernate.dialect.PostgreSQL81Dialect;
import org.hibernate.dialect.PostgreSQL82Dialect;
import org.hibernate.dialect.PostgreSQL91Dialect;
import org.hibernate.dialect.PostgreSQL92Dialect;
import org.hibernate.dialect.PostgreSQL93Dialect;
import org.hibernate.dialect.PostgreSQL94Dialect;
import org.hibernate.dialect.PostgreSQL95Dialect;
import org.hibernate.dialect.PostgreSQL9Dialect;
import org.hibernate.dialect.SQLServer2005Dialect;
import org.hibernate.dialect.SQLServer2008Dialect;
import org.hibernate.dialect.SQLServer2012Dialect;
import org.hibernate.dialect.SQLServerDialect;

@AutomaticFeature
@Internal
final class HibernateFeature
implements Feature {
    HibernateFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.registerIfPresent(access, "org.h2.Driver", H2Dialect.class);
        Class[] postgresDialects = new Class[]{PostgreSQL9Dialect.class, PostgreSQL10Dialect.class, PostgreSQL91Dialect.class, PostgreSQL92Dialect.class, PostgreSQL93Dialect.class, PostgreSQL94Dialect.class, PostgreSQL95Dialect.class, PostgreSQL81Dialect.class, PostgreSQL82Dialect.class};
        this.registerIfPresent(access, "org.postgresql.Driver", postgresDialects);
        this.registerIfPresent(access, "io.vertx.pgclient.spi.PgDriver", postgresDialects);
        Class[] mariaDialects = new Class[]{MariaDBDialect.class, MariaDB10Dialect.class, MariaDB102Dialect.class, MariaDB103Dialect.class, MariaDB53Dialect.class};
        this.registerIfPresent(access, "org.mariadb.jdbc.Driver", mariaDialects);
        this.registerIfPresent(access, "io.vertx.mysqlclient.spi.MySQLDriver", mariaDialects);
        Class[] oracleDialects = new Class[]{Oracle8iDialect.class, Oracle9iDialect.class, Oracle10gDialect.class, Oracle12cDialect.class};
        this.registerIfPresent(access, "oracle.jdbc.OracleDriver", oracleDialects);
        this.registerIfPresent(access, "io.vertx.oracleclient.spi.OracleDriver", oracleDialects);
        Class[] sqlServerDialects = new Class[]{SQLServerDialect.class, SQLServer2005Dialect.class, SQLServer2008Dialect.class, SQLServer2012Dialect.class};
        this.registerIfPresent(access, "com.microsoft.sqlserver.jdbc.SQLServerDriver", sqlServerDialects);
        this.registerIfPresent(access, "io.vertx.mssqlclient.spi.MSSQLDriver", sqlServerDialects);
        Class[] mysqlDialects = new Class[]{MySQL5Dialect.class, MySQL55Dialect.class, MySQL57Dialect.class, MySQL8Dialect.class};
        this.registerIfPresent(access, "com.mysql.cj.jdbc.Driver", mysqlDialects);
        this.registerIfPresent(access, "io.vertx.mysqlclient.spi.MySQLDriver", mysqlDialects);
    }

    private void registerIfPresent(Feature.BeforeAnalysisAccess access, String name, Class<?> ... dialects) {
        boolean present;
        Class driver = access.findClassByName(name);
        boolean bl = present = driver != null;
        if (present) {
            for (Class<?> dialect : dialects) {
                AutomaticFeatureUtils.registerClassForRuntimeReflectionAndReflectiveInstantiation((Feature.BeforeAnalysisAccess)access, (String)dialect.getName());
            }
        }
    }
}

