/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.hibernate.jpa.proxy;

import io.micronaut.configuration.hibernate.jpa.proxy.IntroducedHibernateProxyFactory;
import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.Internal;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.InstantiationException;
import org.hibernate.bytecode.spi.BasicProxyFactory;
import org.hibernate.bytecode.spi.ProxyFactoryFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.type.CompositeType;

@Internal
final class IntroducedHibernateProxyFactoryFactory
implements ProxyFactoryFactory {
    private static final ProxyFactory NO_PROXY_FACTORY = new ProxyFactory(){

        public void postInstantiate(String entityName, Class persistentClass, Set<Class> interfaces, Method getIdentifierMethod, Method setIdentifierMethod, CompositeType componentIdType) throws HibernateException {
        }

        public HibernateProxy getProxy(Serializable id, SharedSessionContractImplementor session) throws HibernateException {
            throw new HibernateException("Generation of HibernateProxy instances at runtime is not allowed when the configured BytecodeProvider is 'none'; your model requires a more advanced BytecodeProvider to be enabled.");
        }
    };

    IntroducedHibernateProxyFactoryFactory() {
    }

    public ProxyFactory buildProxyFactory(SessionFactoryImplementor sessionFactory) {
        ManagedBeanRegistry beanRegistry = (ManagedBeanRegistry)sessionFactory.getServiceRegistry().getService(ManagedBeanRegistry.class);
        try {
            BeanContext beanContext = (BeanContext)beanRegistry.getBean(BeanContext.class).getBeanInstance();
            return new IntroducedHibernateProxyFactory(beanContext);
        }
        catch (InstantiationException e) {
            return NO_PROXY_FACTORY;
        }
    }

    public BasicProxyFactory buildBasicProxyFactory(Class superClass, Class[] interfaces) {
        return () -> {
            throw new HibernateException("NoneBasicProxyFactory is unable to generate a BasicProxy for type " + superClass + " and interfaces " + Arrays.toString(interfaces) + ". Enable a different BytecodeProvider.");
        };
    }

    public BasicProxyFactory buildBasicProxyFactory(Class superClassOrInterface) {
        return () -> {
            throw new HibernateException("NoneBasicProxyFactory is unable to generate a BasicProxy for type " + superClassOrInterface + ". Enable a different BytecodeProvider.");
        };
    }
}

