/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.hibernate.jpa.proxy;

import io.micronaut.configuration.hibernate.jpa.proxy.IntroducedHibernateProxyFactoryFactory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.naming.Named;
import jakarta.inject.Singleton;
import java.util.Arrays;
import java.util.Optional;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.bytecode.spi.BytecodeProvider;
import org.hibernate.bytecode.spi.ProxyFactoryFactory;
import org.hibernate.bytecode.spi.ReflectionOptimizer;

@Singleton
@Internal
public final class IntrospectedHibernateBytecodeProvider
implements BytecodeProvider {
    private static final Enhancer NO_OP = (className, originalBytes) -> null;

    public ProxyFactoryFactory getProxyFactoryFactory() {
        return new IntroducedHibernateProxyFactoryFactory();
    }

    public ReflectionOptimizer getReflectionOptimizer(Class clazz, String[] getterNames, String[] setterNames, Class[] types) {
        Optional optionalBeanIntrospection = BeanIntrospector.SHARED.findIntrospection(clazz);
        return optionalBeanIntrospection.map(beanIntrospection -> new ReflectionOptimizer((BeanIntrospection)beanIntrospection){
            final /* synthetic */ BeanIntrospection val$beanIntrospection;
            {
                this.val$beanIntrospection = beanIntrospection;
            }

            public ReflectionOptimizer.InstantiationOptimizer getInstantiationOptimizer() {
                return () -> ((BeanIntrospection)this.val$beanIntrospection).instantiate();
            }

            public ReflectionOptimizer.AccessOptimizer getAccessOptimizer() {
                final BeanProperty[] beanProperties = this.val$beanIntrospection.getBeanProperties().toArray(new BeanProperty[0]);
                return new ReflectionOptimizer.AccessOptimizer(){
                    private final String[] propertyNames;
                    {
                        this.propertyNames = (String[])Arrays.stream(beanProperties).map(Named::getName).toArray(String[]::new);
                    }

                    public String[] getPropertyNames() {
                        return this.propertyNames;
                    }

                    public Object[] getPropertyValues(Object object) {
                        Object[] values = new Object[beanProperties.length];
                        for (int i = 0; i < beanProperties.length; ++i) {
                            BeanProperty beanProperty = beanProperties[i];
                            values[i] = beanProperty.get((Object)i);
                        }
                        return values;
                    }

                    public void setPropertyValues(Object object, Object[] values) {
                        for (int i = 0; i < beanProperties.length; ++i) {
                            BeanProperty beanProperty = beanProperties[i];
                            beanProperty.set(object, values[i]);
                        }
                    }
                };
            }
        }).orElse(null);
    }

    public Enhancer getEnhancer(EnhancementContext enhancementContext) {
        return NO_OP;
    }
}

