/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.hibernate.jpa.validation;

import jakarta.inject.Singleton;
import java.lang.annotation.ElementType;
import javax.persistence.Persistence;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JPATraversableResolver
implements TraversableResolver {
    private static final Logger LOG = LoggerFactory.getLogger(JPATraversableResolver.class);

    public final boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Calling isReachable on object {} with node name {}.", traversableObject, (Object)traversableProperty.getName());
        }
        if (traversableObject == null) {
            return true;
        }
        return Persistence.getPersistenceUtil().isLoaded(traversableObject, traversableProperty.getName());
    }

    public final boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        return true;
    }
}

