/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.hibernate.jpa.conf.serviceregistry.builder.supplier.internal;

import io.micronaut.configuration.hibernate.jpa.JpaConfiguration;
import io.micronaut.configuration.hibernate.jpa.conf.serviceregistry.builder.supplier.StandardServiceRegistryBuilderCreator;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.integrator.spi.Integrator;

@Internal
@Requires(missingBeans={StandardServiceRegistryBuilderCreator.class})
@Prototype
final class DefaultStandardServiceRegistryBuilderCreatorCreator
implements StandardServiceRegistryBuilderCreator {
    private final BootstrapServiceRegistry bootstrapServiceRegistry;

    public DefaultStandardServiceRegistryBuilderCreatorCreator(@Primary @Nullable Integrator integrator, ApplicationContext applicationContext) {
        BootstrapServiceRegistryBuilder bootstrapServiceRegistryBuilder = new BootstrapServiceRegistryBuilder();
        bootstrapServiceRegistryBuilder.applyClassLoader(applicationContext.getClassLoader());
        if (integrator != null) {
            bootstrapServiceRegistryBuilder.applyIntegrator(integrator);
        }
        this.bootstrapServiceRegistry = bootstrapServiceRegistryBuilder.build();
    }

    @Override
    public StandardServiceRegistryBuilder create(JpaConfiguration jpaConfiguration) {
        if (jpaConfiguration.isCompileTimeHibernateProxies()) {
            System.setProperty("hibernate.bytecode.provider", "none");
        }
        if (jpaConfiguration.isReactive()) {
            throw new IllegalStateException("Hibernate Reactive not found on classpath!");
        }
        return new StandardServiceRegistryBuilder(this.bootstrapServiceRegistry);
    }
}

