/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.hibernate.jpa.conf;

import io.micronaut.configuration.hibernate.jpa.JpaConfiguration;
import io.micronaut.configuration.hibernate.jpa.conf.AbstractHibernateFactory;
import io.micronaut.configuration.hibernate.jpa.conf.serviceregistry.builder.configures.StandardServiceRegistryBuilderConfigurer;
import io.micronaut.configuration.hibernate.jpa.conf.serviceregistry.builder.supplier.StandardServiceRegistryBuilderCreator;
import io.micronaut.configuration.hibernate.jpa.conf.sessionfactory.configure.SessionFactoryBuilderConfigurer;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.context.exceptions.DisabledBeanException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.TypeHint;
import java.util.List;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.service.ServiceRegistry;

@Internal
@Requires(missingClasses={"org.hibernate.reactive.provider.ReactiveServiceRegistryBuilder"})
@TypeHint(typeNames={"org.hibernate.reactive.provider.ReactiveServiceRegistryBuilder"})
@Factory
final class SessionFactoryPerDataSourceFactory
extends AbstractHibernateFactory {
    private final JpaConfiguration defaultJpaConfiguration;

    SessionFactoryPerDataSourceFactory(Environment environment, List<SessionFactoryBuilderConfigurer> configures, StandardServiceRegistryBuilderCreator serviceRegistryBuilderSupplier, List<StandardServiceRegistryBuilderConfigurer> standardServiceRegistryBuilderConfigurers, @Primary @Nullable JpaConfiguration jpaConfiguration, ApplicationContext applicationContext, @Primary @Nullable Integrator integrator) {
        super(environment, configures, serviceRegistryBuilderSupplier, standardServiceRegistryBuilderConfigurers);
        this.defaultJpaConfiguration = jpaConfiguration != null ? jpaConfiguration : new JpaConfiguration(applicationContext, integrator);
    }

    @EachBean(value=DataSource.class)
    ServiceRegistry buildHibernateStandardServiceRegistry(@Parameter @Nullable JpaConfiguration jpaConfiguration, @Parameter String name) {
        if (jpaConfiguration == null) {
            jpaConfiguration = this.defaultJpaConfiguration.copy(name);
        } else if (!jpaConfiguration.isEnabled()) {
            throw new DisabledBeanException("JPA configuration for datasource [" + name + "] is disabled");
        }
        return super.buildHibernateStandardServiceRegistry(jpaConfiguration);
    }

    @Override
    @EachBean(value=ServiceRegistry.class)
    MetadataSources buildMetadataSources(ServiceRegistry serviceRegistry) {
        return super.buildMetadataSources(serviceRegistry);
    }

    @EachBean(value=MetadataSources.class)
    Metadata buildMetadata(MetadataSources metadataSources, @Parameter @Nullable JpaConfiguration jpaConfiguration, @Parameter String name) {
        if (jpaConfiguration == null) {
            jpaConfiguration = this.defaultJpaConfiguration.copy(name);
        }
        return super.buildMetadata(metadataSources, jpaConfiguration);
    }

    @EachBean(value=Metadata.class)
    SessionFactoryBuilder buildHibernateSessionFactoryBuilder(Metadata metadata, @Parameter @Nullable JpaConfiguration jpaConfiguration, @Parameter String name) {
        if (jpaConfiguration == null) {
            jpaConfiguration = this.defaultJpaConfiguration.copy(name);
        }
        return super.buildHibernateSessionFactoryBuilder(metadata, jpaConfiguration);
    }

    @Bean(preDestroy="close")
    @Context
    @EachBean(value=SessionFactoryBuilder.class)
    SessionFactory buildHibernateSessionFactoryBuilder(SessionFactoryBuilder sessionFactoryBuilder) {
        return super.buildHibernateSessionFactory(sessionFactoryBuilder);
    }
}

