/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.hibernate.jpa.conf.settings.internal;

import io.micronaut.configuration.hibernate.jpa.JpaConfiguration;
import io.micronaut.configuration.hibernate.jpa.conf.settings.SettingsSupplier;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Any;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.jdbc.DataSourceResolver;
import java.util.Collections;
import java.util.Map;
import javax.sql.DataSource;

@Internal
@Requires(classes={DataSource.class, DataSourceResolver.class})
@Prototype
final class DataSourceSettingSupplier
implements SettingsSupplier {
    @Any
    private final BeanProvider<DataSource> dataSourceBeanProvider;
    private final DataSourceResolver dataSourceResolver;

    DataSourceSettingSupplier(BeanProvider<DataSource> dataSourceBeanProvider, @Nullable DataSourceResolver dataSourceResolver) {
        this.dataSourceBeanProvider = dataSourceBeanProvider;
        this.dataSourceResolver = dataSourceResolver;
    }

    @Override
    public Map<String, Object> supply(JpaConfiguration jpaConfiguration) {
        DataSource dataSource = this.dataSourceBeanProvider.find(Qualifiers.byName((String)jpaConfiguration.getName())).orElse(null);
        if (dataSource == null) {
            return Collections.emptyMap();
        }
        if (this.dataSourceResolver != null) {
            dataSource = this.dataSourceResolver.resolve(dataSource);
        }
        return Collections.singletonMap("jakarta.persistence.nonJtaDataSource", dataSource);
    }
}

