/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.hibernate.jpa.proxy;

import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.configuration.hibernate.jpa.proxy.IntroducedHibernateProxy;
import io.micronaut.configuration.hibernate.jpa.proxy.IntroducedHibernateProxyLazyInitializer;
import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.type.CompositeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
final class IntroducedHibernateProxyFactory
implements ProxyFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntroducedHibernateProxyFactory.class);
    private static final Set<Class<?>> EXPECTED_INTERFACES = Collections.singleton(HibernateProxy.class);
    private static final String GET_HIBERNATE_LAZY_INITIALIZER = "getHibernateLazyInitializer";
    private final BeanContext beanContext;
    private String entityName;
    private Class<?> persistentClass;
    private CompositeType componentIdType;
    private Method getIdentifierMethod;
    private Method setIdentifierMethod;
    private BeanDefinition<?> beanDefinition;

    public IntroducedHibernateProxyFactory(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    public void postInstantiate(String entityName, Class<?> persistentClass, Set<Class<?>> interfaces, Method getIdentifierMethod, Method setIdentifierMethod, CompositeType componentIdType) throws HibernateException {
        this.getIdentifierMethod = getIdentifierMethod;
        this.setIdentifierMethod = setIdentifierMethod;
        this.entityName = entityName;
        this.persistentClass = persistentClass;
        this.componentIdType = componentIdType;
        if (LOGGER.isWarnEnabled() && !EXPECTED_INTERFACES.equals(interfaces)) {
            LOGGER.warn("Expected a single set of 'org.hibernate.proxy.HibernateProxy.class' got {}", interfaces);
        }
    }

    public HibernateProxy getProxy(Object id, SharedSessionContractImplementor session) throws HibernateException {
        if (this.beanDefinition == null) {
            this.beanDefinition = (BeanDefinition)this.beanContext.findBeanDefinition(this.persistentClass, null).orElseThrow(() -> new HibernateException("Cannot find a proxy class, please annotate " + String.valueOf(this.persistentClass) + " with @GenerateProxy."));
        }
        IntroducedHibernateProxyLazyInitializer lazyInitializer = new IntroducedHibernateProxyLazyInitializer(this.entityName, this.persistentClass, id, session);
        Object proxyTargetBean = this.beanContext.getBean(this.beanDefinition);
        IntroducedHibernateProxy introducedHibernateProxy = (IntroducedHibernateProxy)proxyTargetBean;
        introducedHibernateProxy.$registerInterceptor((MethodInterceptor<Object, Object>)((MethodInterceptor)arg_0 -> this.lambda$getProxy$1((LazyInitializer)lazyInitializer, arg_0)));
        return introducedHibernateProxy;
    }

    private /* synthetic */ Object lambda$getProxy$1(LazyInitializer lazyInitializer, MethodInvocationContext context) {
        String methodName = context.getMethodName();
        if (context.getDeclaringType() == HibernateProxy.class) {
            if (GET_HIBERNATE_LAZY_INITIALIZER.equals(methodName)) {
                return lazyInitializer;
            }
            throw new HibernateException("InterceptedHibernateProxyFactory doesn't support serializing proxies");
        }
        Object[] parameterValues = context.getParameterValues();
        int params = parameterValues.length;
        if (params == 0 && this.getIdentifierMethod != null && methodName.equals(this.getIdentifierMethod.getName()) && lazyInitializer.isUninitialized()) {
            return lazyInitializer.getIdentifier();
        }
        if (params == 1 && this.setIdentifierMethod != null & methodName.equals(this.setIdentifierMethod.getName())) {
            lazyInitializer.initialize();
            lazyInitializer.setIdentifier(parameterValues[0]);
        }
        ExecutableMethod executableMethod = context.getExecutableMethod();
        if (this.componentIdType != null && this.componentIdType.isMethodOf(executableMethod.getTargetMethod())) {
            return executableMethod.invoke(lazyInitializer.getIdentifier(), parameterValues);
        }
        return executableMethod.invoke(lazyInitializer.getImplementation(), parameterValues);
    }
}

