/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.hibernate.jpa;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.convert.format.MapFormat;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.Toggleable;
import jakarta.inject.Inject;
import jakarta.persistence.Entity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.integrator.spi.Integrator;

@EachProperty(value="jpa", primary="default")
public class JpaConfiguration
implements Toggleable {
    public static final String PREFIX = "jpa";
    public static final String PRIMARY = "default";
    private final String name;
    private final ApplicationContext applicationContext;
    private final Integrator integrator;
    private Map<String, Object> jpaProperties = new HashMap<String, Object>(10);
    private List<String> mappingResources = new ArrayList<String>();
    private EntityScanConfiguration entityScanConfiguration;
    private boolean compileTimeHibernateProxies;
    private boolean reactive;
    private boolean enabled = true;

    public JpaConfiguration(ApplicationContext applicationContext, @Nullable Integrator integrator) {
        this(PRIMARY, integrator, applicationContext, new EntityScanConfiguration(applicationContext.getEnvironment()));
    }

    public JpaConfiguration(@Parameter String name, ApplicationContext applicationContext, @Nullable Integrator integrator) {
        this(name, integrator, applicationContext, new EntityScanConfiguration(applicationContext.getEnvironment()));
    }

    @Inject
    protected JpaConfiguration(@Parameter String name, @Nullable Integrator integrator, ApplicationContext applicationContext, @Nullable EntityScanConfiguration entityScanConfiguration) {
        this.name = name;
        this.entityScanConfiguration = entityScanConfiguration != null ? entityScanConfiguration : new EntityScanConfiguration(applicationContext.getEnvironment());
        this.applicationContext = applicationContext;
        this.integrator = integrator;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public EntityScanConfiguration getEntityScanConfiguration() {
        return this.entityScanConfiguration;
    }

    public void setPackagesToScan(String ... packagesToScan) {
        if (ArrayUtils.isNotEmpty((Object[])packagesToScan)) {
            EntityScanConfiguration entityScanConfiguration = new EntityScanConfiguration(this.applicationContext.getEnvironment());
            entityScanConfiguration.setPackages(packagesToScan);
            this.entityScanConfiguration = entityScanConfiguration;
        }
    }

    public String[] getPackagesToScan() {
        return this.entityScanConfiguration.getPackages();
    }

    public final void setProperties(@MapFormat(transformation=MapFormat.MapTransformation.FLAT, keyFormat=StringConvention.RAW) @NonNull Map<String, Object> jpaProperties) {
        this.jpaProperties = jpaProperties;
    }

    @NonNull
    public Map<String, Object> getProperties() {
        return this.jpaProperties;
    }

    @NonNull
    public List<String> getMappingResources() {
        return this.mappingResources;
    }

    public void setMappingResources(List<String> mappingResources) {
        this.mappingResources = mappingResources;
    }

    public boolean isCompileTimeHibernateProxies() {
        return this.compileTimeHibernateProxies;
    }

    public void setCompileTimeHibernateProxies(boolean compileTimeHibernateProxies) {
        this.compileTimeHibernateProxies = compileTimeHibernateProxies;
    }

    public boolean isReactive() {
        return this.reactive;
    }

    public void setReactive(boolean reactive) {
        this.reactive = reactive;
    }

    public JpaConfiguration copy(String name) {
        JpaConfiguration jpaConfiguration = new JpaConfiguration(name, this.integrator, this.applicationContext, this.entityScanConfiguration);
        jpaConfiguration.setProperties(new HashMap<String, Object>(this.getProperties()));
        jpaConfiguration.setMappingResources(new ArrayList<String>(this.getMappingResources()));
        jpaConfiguration.setCompileTimeHibernateProxies(this.compileTimeHibernateProxies);
        jpaConfiguration.setReactive(this.reactive);
        return jpaConfiguration;
    }

    @ConfigurationProperties(value="entity-scan")
    public static class EntityScanConfiguration
    implements Toggleable {
        private boolean enabled = true;
        private String[] packages = StringUtils.EMPTY_STRING_ARRAY;
        private final Environment environment;

        public EntityScanConfiguration(Environment environment) {
            this.environment = environment;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String[] getPackages() {
            return this.packages;
        }

        public void setPackages(String[] packages) {
            this.packages = packages;
        }

        public Collection<Class<?>> findEntities() {
            HashSet entities = new HashSet();
            if (this.isEnabled()) {
                if (ArrayUtils.isNotEmpty((Object[])this.packages)) {
                    entities.addAll(this.environment.scan(Entity.class, this.packages).collect(Collectors.toSet()));
                } else {
                    entities.addAll(BeanIntrospector.SHARED.findIntrospections(Entity.class).stream().map(BeanIntrospection::getBeanType).collect(Collectors.toSet()));
                }
            }
            return Collections.unmodifiableCollection(entities);
        }
    }
}

