/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.hibernate.jpa.conf.settings.internal;

import io.micronaut.configuration.hibernate.jpa.JpaConfiguration;
import io.micronaut.configuration.hibernate.jpa.conf.settings.SettingsSupplier;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.Collections;
import java.util.Map;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.resource.beans.container.spi.ContainedBean;
import org.hibernate.resource.beans.spi.BeanInstanceProducer;

@Internal
@Prototype
final class MicronautContainerSettingsSupplier
implements SettingsSupplier {
    private final ApplicationContext applicationContext;

    MicronautContainerSettingsSupplier(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public Map<String, Object> supply(JpaConfiguration jpaConfiguration) {
        BeanContainer beanContainer = new BeanContainer(){

            public <B> ContainedBean<B> getBean(Class<B> beanType, BeanContainer.LifecycleOptions lifecycleOptions, BeanInstanceProducer fallbackProducer) {
                final Object bean = MicronautContainerSettingsSupplier.this.applicationContext.findBean(beanType).orElseGet(() -> fallbackProducer.produceBeanInstance(beanType));
                return new ContainedBean<B>(this){

                    public Class<B> getBeanClass() {
                        return bean.getClass();
                    }

                    public B getBeanInstance() {
                        return bean;
                    }
                };
            }

            public <B> ContainedBean<B> getBean(String name, Class<B> beanType, BeanContainer.LifecycleOptions lifecycleOptions, BeanInstanceProducer fallbackProducer) {
                final Object bean = MicronautContainerSettingsSupplier.this.applicationContext.findBean(beanType, Qualifiers.byName((String)name)).orElseGet(() -> fallbackProducer.produceBeanInstance(name, beanType));
                return new ContainedBean<B>(this){

                    public Class<B> getBeanClass() {
                        return bean.getClass();
                    }

                    public B getBeanInstance() {
                        return bean;
                    }
                };
            }

            public void stop() {
            }
        };
        return Collections.singletonMap("hibernate.resource.beans.container", beanContainer);
    }
}

