/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.hibernate.jpa.proxy;

import io.micronaut.core.annotation.Internal;
import org.hibernate.LazyInitializationException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.AbstractLazyInitializer;

@Internal
final class IntroducedHibernateProxyLazyInitializer
extends AbstractLazyInitializer {
    protected final Class<?> persistentClass;

    protected IntroducedHibernateProxyLazyInitializer(String entityName, Class<?> persistentClass, Object id, SharedSessionContractImplementor session) {
        super(entityName, id, session);
        this.persistentClass = persistentClass;
    }

    public Class<?> getPersistentClass() {
        return this.persistentClass;
    }

    public Class<?> getImplementationClass() {
        if (!this.isUninitialized()) {
            return this.getImplementation().getClass();
        }
        SharedSessionContractImplementor session = this.getSession();
        if (session == null) {
            throw new LazyInitializationException("could not retrieve real entity class [" + this.getEntityName() + "#" + String.valueOf(this.getIdentifier()) + "] - no Session");
        }
        SessionFactoryImplementor factory = session.getFactory();
        EntityPersister entityDescriptor = factory.getMappingMetamodel().getEntityDescriptor(this.getEntityName());
        if (entityDescriptor.getEntityMappingType().hasSubclasses()) {
            return this.getImplementation().getClass();
        }
        return this.persistentClass;
    }
}

