/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.hibernate.reactive.conf;

import io.micronaut.configuration.hibernate.jpa.JpaConfiguration;
import io.micronaut.configuration.hibernate.jpa.conf.settings.SettingsSupplier;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Requires;
import io.vertx.sqlclient.Pool;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.reactive.pool.impl.SqlClientPool;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;

@Requires(bean=Pool.class)
@Prototype
final class ExternalVertxSqlClientPoolSettingSupplier
implements SettingsSupplier {
    private final Pool pool;

    ExternalVertxSqlClientPoolSettingSupplier(Pool pool) {
        this.pool = pool;
    }

    public Map<String, Object> supply(JpaConfiguration jpaConfiguration) {
        return Collections.singletonMap("hibernate.vertx.pool.class", new ExternalSqlClientPool(this.pool));
    }

    private static final class ExternalSqlClientPool
    extends SqlClientPool
    implements ServiceRegistryAwareService {
        private final transient Pool pool;
        private transient SqlStatementLogger sqlStatementLogger;
        private transient SqlExceptionHelper sqlExceptionHelper;
        private transient ServiceRegistryImplementor serviceRegistry;

        private ExternalSqlClientPool(Pool pool) {
            this.pool = pool;
        }

        protected Pool getPool() {
            return this.pool;
        }

        protected SqlStatementLogger getSqlStatementLogger() {
            return this.sqlStatementLogger;
        }

        protected SqlExceptionHelper getSqlExceptionHelper() {
            if (this.sqlExceptionHelper == null) {
                this.sqlExceptionHelper = ((JdbcServices)this.serviceRegistry.getService(JdbcServices.class)).getSqlExceptionHelper();
            }
            return this.sqlExceptionHelper;
        }

        public CompletionStage<Void> getCloseFuture() {
            return CompletionStages.voidFuture();
        }

        public void injectServices(ServiceRegistryImplementor serviceRegistry) {
            this.serviceRegistry = serviceRegistry;
            this.sqlStatementLogger = ((JdbcServices)serviceRegistry.getService(JdbcServices.class)).getSqlStatementLogger();
        }
    }
}

