/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.hibernate.reactive.conf;

import io.micronaut.configuration.hibernate.jpa.JpaConfiguration;
import io.micronaut.configuration.hibernate.jpa.conf.serviceregistry.builder.supplier.StandardServiceRegistryBuilderCreator;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.reactive.provider.ReactiveServiceRegistryBuilder;

@Requires(classes={ReactiveServiceRegistryBuilder.class})
@Prototype
final class ReactiveRegistryCreator
implements StandardServiceRegistryBuilderCreator {
    private final BootstrapServiceRegistry bootstrapServiceRegistry;

    public ReactiveRegistryCreator(@Primary @Nullable Integrator integrator, ApplicationContext applicationContext) {
        BootstrapServiceRegistryBuilder bootstrapServiceRegistryBuilder = new BootstrapServiceRegistryBuilder();
        bootstrapServiceRegistryBuilder.applyClassLoader(applicationContext.getClassLoader());
        if (integrator != null) {
            bootstrapServiceRegistryBuilder.applyIntegrator(integrator);
        }
        this.bootstrapServiceRegistry = bootstrapServiceRegistryBuilder.build();
    }

    public StandardServiceRegistryBuilder create(JpaConfiguration jpaConfiguration) {
        return jpaConfiguration.isReactive() ? new ReactiveServiceRegistryBuilder(this.bootstrapServiceRegistry) : new StandardServiceRegistryBuilder(this.bootstrapServiceRegistry);
    }
}

