/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.jasync;

import com.github.jasync.sql.db.ConnectionPoolConfiguration;
import com.github.jasync.sql.db.ConnectionPoolConfigurationBuilder;
import com.github.jasync.sql.db.SSLConfiguration;
import com.github.jasync.sql.db.interceptor.QueryInterceptor;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationInject;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.bind.annotation.Bindable;
import java.io.File;
import java.util.List;

@ConfigurationProperties(value="jasync.client")
public class JasyncPoolConfiguration {
    @ConfigurationBuilder
    protected ConnectionPoolConfigurationBuilder jasyncOptions = new ConnectionPoolConfigurationBuilder();

    protected JasyncPoolConfiguration(@Nullable JasyncSslConfiguration sslConfiguration, @Nullable List<QueryInterceptor> queryInterceptors) {
        if (sslConfiguration != null) {
            this.jasyncOptions.setSsl(sslConfiguration.getSslConfiguration());
        }
        if (queryInterceptors != null) {
            this.jasyncOptions.setInterceptors(queryInterceptors.stream().map(x -> () -> x).toList());
        }
    }

    public ConnectionPoolConfiguration getJasyncOptions() {
        return this.jasyncOptions.build();
    }

    @ConfigurationProperties(value="ssl")
    @Requires(property="jasync.client.ssl")
    public static class JasyncSslConfiguration {
        private final SSLConfiguration sslConfiguration;

        @ConfigurationInject
        public JasyncSslConfiguration(@Bindable(defaultValue="Disable") SSLConfiguration.Mode mode, @Nullable String rootCert, @Nullable String clientCert, @Nullable String clientPrivateKey) {
            this.sslConfiguration = new SSLConfiguration(mode, rootCert != null ? new File(rootCert) : null, clientCert != null ? new File(clientCert) : null, clientPrivateKey != null ? new File(clientPrivateKey) : null);
        }

        @NonNull
        public SSLConfiguration getSslConfiguration() {
            return this.sslConfiguration;
        }
    }
}

