/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.jasync;

import com.github.jasync.sql.db.Connection;
import com.github.jasync.sql.db.ConnectionPoolConfigurationBuilder;
import com.github.jasync.sql.db.pool.ConnectionPool;
import com.github.jasync.sql.db.postgresql.PostgreSQLConnection;
import com.github.jasync.sql.db.postgresql.PostgreSQLConnectionBuilder;
import io.micronaut.configuration.jasync.JasyncPoolConfiguration;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Singleton;

@Factory
@Requires(classes={PostgreSQLConnectionBuilder.class})
public class JasyncPostgreSQLClientFactory
implements AutoCloseable {
    private final JasyncPoolConfiguration jasyncPoolConfiguration;
    private ConnectionPool<PostgreSQLConnection> connection;

    public JasyncPostgreSQLClientFactory(JasyncPoolConfiguration jasyncPoolConfiguration) {
        this.jasyncPoolConfiguration = jasyncPoolConfiguration;
    }

    @Singleton
    public Connection client() {
        if (this.connection == null || !this.connection.isConnected()) {
            this.connection = PostgreSQLConnectionBuilder.createConnectionPool((ConnectionPoolConfigurationBuilder)this.jasyncPoolConfiguration.jasyncOptions);
        }
        return this.connection;
    }

    @Override
    @PreDestroy
    public void close() {
        if (this.connection != null && this.connection.isConnected()) {
            this.connection.disconnect();
        }
    }
}

