/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.jasync.health;

import com.github.jasync.sql.db.Connection;
import com.github.jasync.sql.db.RowData;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.endpoint.health.HealthEndpoint;
import io.micronaut.management.health.indicator.HealthIndicator;
import io.micronaut.management.health.indicator.HealthResult;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@Requirements(value={@Requires(beans={HealthEndpoint.class}), @Requires(property="endpoints.health.jasync.enabled", notEquals="false")})
@Singleton
public class JasyncHealthIndicator
implements HealthIndicator {
    public static final String NAME = "postgres-reactive";
    public static final String QUERY = "SELECT version();";
    private final Connection client;

    public JasyncHealthIndicator(Connection client) {
        this.client = client;
    }

    public Publisher<HealthResult> getResult() {
        return Mono.fromFuture((CompletableFuture)this.client.sendQuery(QUERY)).map(queryResult -> {
            HashMap<String, String> error = new HashMap<String, String>(1);
            error.put("version", String.valueOf(((RowData)queryResult.getRows().get(0)).get(0)));
            return HealthResult.builder((String)NAME, (HealthStatus)HealthStatus.UP).details(error).build();
        }).onErrorResume(error -> Mono.just((Object)HealthResult.builder((String)NAME, (HealthStatus)HealthStatus.DOWN).exception(error).build()));
    }
}

