/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.jdbc.dbcp;

import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Property;
import io.micronaut.core.convert.format.MapFormat;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.jdbc.BasicJdbcConfiguration;
import io.micronaut.jdbc.CalculatedSettings;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Map;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Context
@EachProperty(value="datasources", primary="default")
public class DatasourceConfiguration
extends BasicDataSource
implements BasicJdbcConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(DatasourceConfiguration.class);
    private final CalculatedSettings calculatedSettings;
    private final String name;

    public DatasourceConfiguration(@Parameter String name) {
        this.name = name;
        this.calculatedSettings = new CalculatedSettings((BasicJdbcConfiguration)this);
    }

    @PostConstruct
    void postConstruct() {
        if (this.getConfiguredUrl() == null) {
            this.setUrl(this.getUrl());
        }
        if (this.getConfiguredDriverClassName() == null) {
            this.setDriverClassName(this.getDriverClassName());
        }
        if (this.getConfiguredUsername() == null) {
            this.setUsername(this.getUsername());
        }
        if (this.getConfiguredPassword() == null) {
            this.setPassword(this.getPassword());
        }
        if (this.getConfiguredValidationQuery() == null) {
            this.setValidationQuery(this.getValidationQuery());
        }
    }

    @PreDestroy
    void preDestroy() {
        block2: {
            try {
                this.close();
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn("Error closing data source [" + this + "]: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDriverClassName() {
        return this.calculatedSettings.getDriverClassName();
    }

    public String getConfiguredDriverClassName() {
        return super.getDriverClassName();
    }

    public String getUrl() {
        return this.calculatedSettings.getUrl();
    }

    public String getConfiguredUrl() {
        return super.getUrl();
    }

    public String getUsername() {
        return this.calculatedSettings.getUsername();
    }

    public String getConfiguredUsername() {
        return super.getUsername();
    }

    public String getPassword() {
        return this.calculatedSettings.getPassword();
    }

    public String getConfiguredPassword() {
        return super.getPassword();
    }

    public String getValidationQuery() {
        return this.calculatedSettings.getValidationQuery();
    }

    public void setConnectionPropertiesString(@Property(name="datasources.*.connection-properties") String connectionProperties) {
        this.setConnectionProperties(connectionProperties);
    }

    public void setDataSourceProperties(@MapFormat(transformation=MapFormat.MapTransformation.FLAT, keyFormat=StringConvention.RAW) Map<String, ?> dsProperties) {
        if (dsProperties != null) {
            dsProperties.forEach((s, o) -> {
                if (o != null) {
                    this.addConnectionProperty((String)s, o.toString());
                }
            });
        }
    }

    public String getConfiguredValidationQuery() {
        return super.getValidationQuery();
    }
}

