/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.jdbc.dbcp;

import io.micronaut.configuration.jdbc.dbcp.metadata.DbcpDataSourcePoolMetadata;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.jdbc.DataSourceResolver;
import io.micronaut.jdbc.metadata.DataSourcePoolMetadata;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;

@Factory
public class DatasourceFactory {
    private final DataSourceResolver dataSourceResolver;

    public DatasourceFactory(@Nullable DataSourceResolver dataSourceResolver) {
        this.dataSourceResolver = dataSourceResolver == null ? DataSourceResolver.DEFAULT : dataSourceResolver;
    }

    @EachBean(value=DataSource.class)
    public DataSourcePoolMetadata<BasicDataSource> dbcpDataSourcePoolMetadata(DataSource dataSource) {
        DbcpDataSourcePoolMetadata dbcpDataSourcePoolMetadata = null;
        DataSource resolved = this.dataSourceResolver.resolve(dataSource);
        if (resolved instanceof BasicDataSource) {
            dbcpDataSourcePoolMetadata = new DbcpDataSourcePoolMetadata((BasicDataSource)resolved);
        }
        return dbcpDataSourcePoolMetadata;
    }
}

