/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.jdbc.dbcp.metadata;

import io.micronaut.jdbc.metadata.AbstractDataSourcePoolMetadata;
import java.lang.reflect.Field;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbcpDataSourcePoolMetadata
extends AbstractDataSourcePoolMetadata<BasicDataSource> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbcpDataSourcePoolMetadata.class);

    public DbcpDataSourcePoolMetadata(BasicDataSource dataSource) {
        super((DataSource)dataSource);
    }

    public Integer getIdle() {
        return this.getConnectionPool().map(GenericObjectPool::getNumIdle).orElse(0);
    }

    public Integer getActive() {
        return this.getConnectionPool().map(GenericObjectPool::getNumActive).orElse(0);
    }

    public Integer getMax() {
        return ((BasicDataSource)this.getDataSource()).getMaxTotal();
    }

    public Integer getMin() {
        return ((BasicDataSource)this.getDataSource()).getMinIdle();
    }

    public String getValidationQuery() {
        return ((BasicDataSource)this.getDataSource()).getValidationQuery();
    }

    public Boolean getDefaultAutoCommit() {
        return Optional.ofNullable(((BasicDataSource)this.getDataSource()).getDefaultAutoCommit()).orElse(false);
    }

    private Optional<GenericObjectPool> getConnectionPool() {
        return Optional.ofNullable(this.extractPool());
    }

    private GenericObjectPool extractPool() {
        GenericObjectPool pool = null;
        try {
            Field poolField = BasicDataSource.class.getDeclaredField("connectionPool");
            if (poolField != null) {
                poolField.setAccessible(true);
                pool = (GenericObjectPool)poolField.get(this.getDataSource());
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.error("Could not get pool from dbcp dataSource", (Throwable)e);
        }
        return pool;
    }
}

