/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.jdbc.hikari;

import io.micrometer.core.instrument.MeterRegistry;
import io.micronaut.configuration.jdbc.hikari.DatasourceConfiguration;
import io.micronaut.configuration.jdbc.hikari.HikariUrlDataSource;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import io.micronaut.jdbc.BaseDatasourceFactory;
import io.micronaut.jdbc.JdbcDataSourceEnabled;
import jakarta.annotation.PreDestroy;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
public class DatasourceFactory
extends BaseDatasourceFactory
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DatasourceFactory.class);
    private final Map<String, HikariUrlDataSource> dataSources = new LinkedHashMap<String, HikariUrlDataSource>(2);

    public DatasourceFactory(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    @Context
    @EachBean(value=DatasourceConfiguration.class)
    @Requires(condition=JdbcDataSourceEnabled.class)
    public DataSource dataSource(DatasourceConfiguration datasourceConfiguration) {
        HikariUrlDataSource ds = new HikariUrlDataSource(datasourceConfiguration);
        this.addMeterRegistry(ds);
        this.dataSources.put(datasourceConfiguration.getName(), ds);
        return ds;
    }

    protected void dataSourceCredentialsChanged(String dataSourceName, BaseDatasourceFactory.DataSourceCredentials dataSourceCredentials) {
        HikariUrlDataSource hikariUrlDataSource = this.dataSources.get(dataSourceName);
        if (hikariUrlDataSource != null) {
            if (dataSourceCredentials.userName() != null) {
                hikariUrlDataSource.setUsername(dataSourceCredentials.userName());
                hikariUrlDataSource.getHikariConfigMXBean().setUsername(dataSourceCredentials.userName());
            }
            if (dataSourceCredentials.password() != null) {
                hikariUrlDataSource.setPassword(dataSourceCredentials.password());
                hikariUrlDataSource.getHikariConfigMXBean().setPassword(dataSourceCredentials.password());
            }
            hikariUrlDataSource.getHikariPoolMXBean().softEvictConnections();
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Datasource with name [{}] not found while trying to propagate datasource credentials changes.", (Object)dataSourceName);
        }
    }

    private void addMeterRegistry(HikariUrlDataSource ds) {
        try {
            MeterRegistry meterRegistry = this.getMeterRegistry();
            if (ds != null && meterRegistry != null && this.applicationContext.getProperty("micronaut.metrics.binders.jdbc.enabled", Boolean.TYPE).orElse(true).booleanValue()) {
                ds.setMetricRegistry(meterRegistry);
            }
        }
        catch (NoClassDefFoundError ignore) {
            LOG.debug("Could not wire metrics to HikariCP as there is no class of type MeterRegistry on the classpath, io.micronaut.micrometer:micrometer-core library missing.");
        }
    }

    private MeterRegistry getMeterRegistry() {
        return this.applicationContext.containsBean(MeterRegistry.class) ? (MeterRegistry)this.applicationContext.getBean(MeterRegistry.class) : null;
    }

    @Override
    @PreDestroy
    public void close() {
        for (HikariUrlDataSource dataSource : this.dataSources.values()) {
            try {
                dataSource.close();
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("Error closing data source [" + String.valueOf((Object)dataSource) + "]: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

