/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.jdbc.ucp;

import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.util.StringUtils;
import io.micronaut.jdbc.BasicJdbcConfiguration;
import io.micronaut.jdbc.CalculatedSettings;
import jakarta.annotation.PostConstruct;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceFactory;
import oracle.ucp.jdbc.PoolDataSourceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EachProperty(value="datasources", primary="default")
@Context
public class DatasourceConfiguration
implements BasicJdbcConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(DatasourceConfiguration.class);
    @ConfigurationBuilder(allowZeroArgs=true, excludes={"connectionFactoryProperties"})
    PoolDataSourceImpl delegate = (PoolDataSourceImpl)PoolDataSourceFactory.getPoolDataSource();
    private CalculatedSettings calculatedSettings;
    private String name;
    private String username;
    private String password;

    public DatasourceConfiguration(@Parameter String name) throws SQLException {
        this.name = name;
        this.delegate.setConnectionPoolName(name);
        this.calculatedSettings = new CalculatedSettings((BasicJdbcConfiguration)this);
    }

    public PoolDataSource getPoolDataSource() {
        return this.delegate;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) throws SQLException {
        this.name = name;
        this.delegate.setConnectionPoolName(name);
    }

    public String getDriverClassName() {
        return this.calculatedSettings.getDriverClassName();
    }

    public void setDriverClassName(String driverClassName) {
        try {
            this.delegate.setConnectionFactoryClassName(driverClassName);
        }
        catch (SQLException e) {
            throw new ConfigurationException("Unable to set driver class name: " + e.getMessage(), (Throwable)e);
        }
    }

    public String getConfiguredDriverClassName() {
        return this.delegate.getConnectionFactoryClassName();
    }

    public String getConfiguredUrl() {
        return this.delegate.getURL();
    }

    public String getUrl() {
        return this.calculatedSettings.getUrl();
    }

    public void setUrl(String url) {
        try {
            this.delegate.setURL(url);
        }
        catch (SQLException e) {
            throw new ConfigurationException("Unable to set datasource URL: " + e.getMessage(), (Throwable)e);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        try {
            this.delegate.setUser(username);
        }
        catch (SQLException e) {
            throw new ConfigurationException("Unable to set datasource username: " + e.getMessage(), (Throwable)e);
        }
    }

    public String getConfiguredUsername() {
        return this.delegate.getUser();
    }

    public String getPassword() {
        return this.calculatedSettings.getPassword();
    }

    public void setPassword(String password) {
        try {
            this.password = password;
            this.delegate.setPassword(password);
        }
        catch (SQLException e) {
            throw new ConfigurationException("Unable to set datasource password: " + e.getMessage(), (Throwable)e);
        }
    }

    public String getConfiguredPassword() {
        return this.password;
    }

    public String getValidationQuery() {
        return this.calculatedSettings.getValidationQuery();
    }

    public void setValidationQuery(String validationQuery) {
        try {
            this.delegate.setSQLForValidateConnection(validationQuery);
        }
        catch (SQLException e) {
            throw new ConfigurationException("Unable to set datasource validation query:" + e.getMessage(), (Throwable)e);
        }
    }

    public void setDataSourceProperties(Map<String, ?> dsProperties) {
        if (dsProperties != null) {
            Properties properties = new Properties();
            dsProperties.forEach((key, value) -> {
                if (value != null) {
                    properties.put(key, value.toString());
                }
            });
            try {
                this.delegate.setConnectionProperties(properties);
            }
            catch (SQLException e) {
                throw new ConfigurationException("Unable to set datasource properties: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getConfiguredValidationQuery() {
        return this.delegate.getSQLForValidateConnection();
    }

    @PostConstruct
    public void initialize() {
        if (StringUtils.isEmpty((CharSequence)this.getConfiguredDriverClassName()) && !StringUtils.isEmpty((CharSequence)this.getDriverClassName())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Configuring calculated driver class name: {}", (Object)this.getDriverClassName());
            }
            this.setDriverClassName(this.getDriverClassName());
        }
        if (StringUtils.isEmpty((CharSequence)this.getConfiguredUrl())) {
            String url;
            block16: {
                url = null;
                try {
                    url = this.getUrl();
                }
                catch (ConfigurationException e) {
                    if (!LOG.isTraceEnabled()) break block16;
                    LOG.trace("Failed to configure calculated url: {}", (Object)e.getMessage());
                }
            }
            if (url != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Configuring calculated url: {}", (Object)this.getUrl());
                }
                this.setUrl(url);
            }
        }
        if (StringUtils.isEmpty((CharSequence)this.getConfiguredValidationQuery())) {
            String validationQuery;
            block17: {
                validationQuery = null;
                try {
                    validationQuery = this.getValidationQuery();
                }
                catch (ConfigurationException e) {
                    if (!LOG.isTraceEnabled()) break block17;
                    LOG.trace("Failed to configure SQL validation query: {}", (Object)e.getMessage());
                }
            }
            if (validationQuery != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Configuring calculated SQL validation query: {}", (Object)this.getValidationQuery());
                }
                this.setValidationQuery(validationQuery);
            }
        }
        if (StringUtils.isEmpty((CharSequence)this.getConfiguredUsername()) && !StringUtils.isEmpty((CharSequence)this.calculatedSettings.getUsername())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Configuring calculated username: {}", (Object)this.calculatedSettings.getUsername());
            }
            this.setUsername(this.calculatedSettings.getUsername());
        }
        if (StringUtils.isEmpty((CharSequence)this.getConfiguredPassword())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Configuring calculated password: *****");
            }
            this.setPassword(this.getPassword());
        }
    }
}

