/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.jdbc.ucp;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.order.Ordered;
import jakarta.inject.Singleton;
import javax.sql.DataSource;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.jdbc.PoolDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requirements(value={@Requires(classes={PoolDataSource.class}), @Requires(property="ucp-manager.enabled", notEquals="false", defaultValue="true")})
@Internal
public class ConnectionPoolManagerListener
implements BeanCreatedEventListener<DataSource>,
Ordered {
    private static final int POSITION = Integer.MAX_VALUE;
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionPoolManagerListener.class);
    private final UniversalConnectionPoolManager connectionPoolManager;

    public ConnectionPoolManagerListener(UniversalConnectionPoolManager connectionPoolManager) {
        this.connectionPoolManager = connectionPoolManager;
    }

    public DataSource onCreated(BeanCreatedEvent<DataSource> event) {
        DataSource dataSource = (DataSource)event.getBean();
        if (dataSource instanceof PoolDataSource) {
            PoolDataSource poolDataSource = (PoolDataSource)dataSource;
            String poolName = poolDataSource.getConnectionPoolName();
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Creating connection pool named: {}", (Object)poolName);
                }
                this.connectionPoolManager.createConnectionPool((UniversalConnectionPoolAdapter)dataSource);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Starting connection pool named: {}", (Object)poolName);
                }
                this.connectionPoolManager.startConnectionPool(poolName);
                if (LOG.isInfoEnabled()) {
                    LOG.info("Connection pool named: {} started", (Object)poolName);
                }
            }
            catch (UniversalConnectionPoolException e) {
                throw new ConfigurationException(String.format("Failed to start connection pool named: %s", poolName), (Throwable)e);
            }
        }
        return (DataSource)event.getBean();
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

