/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.jdbc.ucp;

import io.micronaut.configuration.jdbc.ucp.DatasourceConfiguration;
import io.micronaut.configuration.jdbc.ucp.UniversalConnectionPoolManagerConfiguration;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.jdbc.JdbcDataSourceEnabled;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.List;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.jdbc.PoolDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
public class DatasourceFactory
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DatasourceFactory.class);
    private final ApplicationContext applicationContext;
    private final UniversalConnectionPoolManagerConfiguration configuration;
    private List<PoolDataSource> dataSources = new ArrayList<PoolDataSource>(2);
    private UniversalConnectionPoolManager connectionPoolManager;

    public DatasourceFactory(ApplicationContext applicationContext) throws UniversalConnectionPoolException {
        this.applicationContext = applicationContext;
        this.configuration = (UniversalConnectionPoolManagerConfiguration)applicationContext.getBean(UniversalConnectionPoolManagerConfiguration.class);
        try {
            this.connectionPoolManager = (UniversalConnectionPoolManager)applicationContext.getBean(UniversalConnectionPoolManager.class);
        }
        catch (NoSuchBeanException noSuchBeanException) {
            // empty catch block
        }
    }

    @Context
    @EachBean(value=DatasourceConfiguration.class)
    @Requires(condition=JdbcDataSourceEnabled.class)
    public PoolDataSource dataSource(DatasourceConfiguration datasourceConfiguration) throws UniversalConnectionPoolException {
        PoolDataSource ds = datasourceConfiguration.getPoolDataSource();
        this.dataSources.add(ds);
        return ds;
    }

    @Override
    @PreDestroy
    public void close() {
        if (this.configuration.isEnabled() && this.connectionPoolManager != null) {
            for (PoolDataSource dataSource : this.dataSources) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Closing connection pool named: {}", (Object)dataSource.getConnectionPoolName());
                    }
                    this.connectionPoolManager.destroyConnectionPool(dataSource.getConnectionPoolName());
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn("Error closing data source [" + dataSource + "]: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

