/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jdbc.metadata;

import io.micronaut.jdbc.metadata.DataSourcePoolMetadata;
import javax.sql.DataSource;

public abstract class AbstractDataSourcePoolMetadata<T extends DataSource>
implements DataSourcePoolMetadata<T> {
    private final T dataSource;

    protected AbstractDataSourcePoolMetadata(T dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public Float getUsage() {
        Integer maxSize = this.getMax();
        Integer currentSize = this.getActive();
        if (maxSize == null || currentSize == null) {
            return null;
        }
        if (maxSize < 0) {
            return Float.valueOf(-1.0f);
        }
        if (currentSize == 0) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf((float)currentSize.intValue() / (float)maxSize.intValue());
    }

    @Override
    public T getDataSource() {
        return this.dataSource;
    }
}

