/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jdbc;

import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.naming.Named;
import io.micronaut.inject.BeanDefinition;

public final class JdbcDataSourceEnabled
implements Condition {
    public boolean matches(ConditionContext context) {
        String dataSourceName;
        AnnotationMetadataProvider annotationMetadataProvider;
        BeanResolutionContext beanResolutionContext = context.getBeanResolutionContext();
        if (beanResolutionContext == null) {
            return true;
        }
        Qualifier currentQualifier = beanResolutionContext.getCurrentQualifier();
        if (currentQualifier == null && (annotationMetadataProvider = context.getComponent()) instanceof BeanDefinition) {
            BeanDefinition definition = (BeanDefinition)annotationMetadataProvider;
            currentQualifier = definition.getDeclaredQualifier();
        }
        if (currentQualifier instanceof Named) {
            Named named = (Named)currentQualifier;
            dataSourceName = named.getName();
        } else {
            dataSourceName = "default";
        }
        String property = "datasources." + dataSourceName + ".enabled";
        return (Boolean)context.getProperty(property, Boolean.class, (Object)true);
    }
}

