/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jdbc;

import io.micronaut.context.ApplicationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.runtime.context.scope.refresh.RefreshEvent;
import io.micronaut.runtime.context.scope.refresh.RefreshEventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class BaseDatasourceFactory
implements RefreshEventListener {
    private static final Pattern DATASOURCE_PASSWORD_MATCHER = Pattern.compile("datasources\\.(.*)\\.password");
    private static final Pattern DATASOURCE_USERNAME_MATCHER = Pattern.compile("datasources\\.(.*)\\.username");
    private static final Logger LOG = LoggerFactory.getLogger(BaseDatasourceFactory.class);
    protected final ApplicationContext applicationContext;

    protected BaseDatasourceFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @NonNull
    public Set<String> getObservedConfigurationPrefixes() {
        return Set.of("datasources");
    }

    public void onApplicationEvent(RefreshEvent event) {
        Map changes = event.getSource();
        if (CollectionUtils.isEmpty((Map)changes)) {
            return;
        }
        HashMap<String, DataSourceCredentials> dataSourceCredentialsMap = new HashMap<String, DataSourceCredentials>(2);
        for (Map.Entry change : changes.entrySet()) {
            String property = (String)change.getKey();
            Matcher userNameMatcher = DATASOURCE_USERNAME_MATCHER.matcher(property);
            if (userNameMatcher.matches()) {
                this.checkAndUpdateUsernameChange(property, userNameMatcher, dataSourceCredentialsMap);
                continue;
            }
            Matcher passwordMatcher = DATASOURCE_PASSWORD_MATCHER.matcher(property);
            if (!passwordMatcher.matches()) continue;
            this.checkAndUpdatePasswordChange(property, passwordMatcher, dataSourceCredentialsMap);
        }
        if (CollectionUtils.isNotEmpty(dataSourceCredentialsMap)) {
            for (Map.Entry dataSourceCredentialsEntry : dataSourceCredentialsMap.entrySet()) {
                String datasourceName = (String)dataSourceCredentialsEntry.getKey();
                DataSourceCredentials dataSourceCredentials = (DataSourceCredentials)dataSourceCredentialsEntry.getValue();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Datasource [{}] credentials changed [{}]. Trying to refresh connection pool.", (Object)datasourceName, (Object)dataSourceCredentials.getChangeType());
                }
                this.dataSourceCredentialsChanged(datasourceName, dataSourceCredentials);
            }
        }
    }

    protected abstract void dataSourceCredentialsChanged(String var1, DataSourceCredentials var2);

    private void checkAndUpdateUsernameChange(String property, Matcher userNameMatcher, Map<String, DataSourceCredentials> dataSourceCredentialsMap) {
        String dataSourceName = userNameMatcher.group(1);
        if (StringUtils.isNotEmpty((CharSequence)dataSourceName)) {
            String userName = (String)this.applicationContext.getRequiredProperty(property, String.class);
            if (StringUtils.isEmpty((CharSequence)userName)) {
                throw new IllegalStateException("Datasource [" + dataSourceName + "] username is changed to empty.");
            }
            DataSourceCredentials dataSourceCredentials = dataSourceCredentialsMap.get(dataSourceName);
            dataSourceCredentialsMap.put(dataSourceName, dataSourceCredentials == null ? new DataSourceCredentials(userName, null) : dataSourceCredentials.withUserName(userName));
        }
    }

    private void checkAndUpdatePasswordChange(String property, Matcher passwordMatcher, Map<String, DataSourceCredentials> dataSourceCredentialsMap) {
        String dataSourceName = passwordMatcher.group(1);
        if (StringUtils.isNotEmpty((CharSequence)dataSourceName)) {
            String password = (String)this.applicationContext.getRequiredProperty(property, String.class);
            DataSourceCredentials dataSourceCredentials = dataSourceCredentialsMap.get(dataSourceName);
            dataSourceCredentialsMap.put(dataSourceName, dataSourceCredentials == null ? new DataSourceCredentials(null, password) : dataSourceCredentials.withPassword(password));
        }
    }

    protected record DataSourceCredentials(@Nullable String userName, @Nullable String password) {
        public DataSourceCredentials withUserName(String newUserName) {
            return new DataSourceCredentials(newUserName, this.password);
        }

        public DataSourceCredentials withPassword(String newPassword) {
            return new DataSourceCredentials(this.userName, newPassword);
        }

        public ChangeType getChangeType() {
            if (this.userName != null && this.password != null) {
                return ChangeType.USERNAME_AND_PASSWORD;
            }
            if (this.userName != null) {
                return ChangeType.USERNAME;
            }
            if (this.password != null) {
                return ChangeType.PASSWORD;
            }
            return ChangeType.NONE;
        }

        static enum ChangeType {
            USERNAME,
            PASSWORD,
            USERNAME_AND_PASSWORD,
            NONE;

        }
    }
}

