/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.jdbi.transaction;

import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.HandleCallback;
import org.jdbi.v3.core.transaction.TransactionHandler;
import org.jdbi.v3.core.transaction.TransactionIsolationLevel;

public abstract class AbstractTransactionHandler
implements TransactionHandler {
    protected final ThreadLocal<Boolean> didTxnRollback = ThreadLocal.withInitial(() -> false);

    public <R, X extends Exception> R inTransaction(Handle handle, HandleCallback<R, X> callback) throws X {
        Object returnValue;
        if (this.isInTransaction(handle)) {
            throw new IllegalStateException("Already in transaction");
        }
        this.didTxnRollback.set(false);
        try {
            handle.begin();
            returnValue = callback.withHandle(handle);
            if (!this.didTxnRollback.get().booleanValue()) {
                handle.commit();
            }
        }
        catch (Throwable e) {
            try {
                handle.rollback();
            }
            catch (Exception rollback) {
                e.addSuppressed(rollback);
            }
            throw e;
        }
        this.didTxnRollback.remove();
        return (R)returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, X extends Exception> R inTransaction(Handle handle, TransactionIsolationLevel level, HandleCallback<R, X> callback) throws X {
        TransactionIsolationLevel initial = handle.getTransactionIsolationLevel();
        try {
            handle.setTransactionIsolation(level);
            R r = this.inTransaction(handle, callback);
            return r;
        }
        finally {
            handle.setTransactionIsolation(initial);
        }
    }
}

