/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.jdbi;

import io.micronaut.configuration.jdbi.JdbiCustomizer;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.reflect.ClassUtils;
import javax.sql.DataSource;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.h2.H2DatabasePlugin;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.StatementBuilderFactory;
import org.jdbi.v3.core.transaction.TransactionHandler;

@Factory
public class JdbiFactory {
    @EachBean(value=DataSource.class)
    public Jdbi jdbi(DataSource dataSource, @Parameter @Nullable TransactionHandler transactionHandler, @Parameter @Nullable StatementBuilderFactory statementBuilderFactory, @Parameter @Nullable JdbiCustomizer jdbiCustomizer) {
        Jdbi jdbi = Jdbi.create((DataSource)dataSource);
        jdbi.installPlugins();
        if (transactionHandler != null) {
            jdbi.setTransactionHandler(transactionHandler);
        }
        if (statementBuilderFactory != null) {
            jdbi.setStatementBuilderFactory(statementBuilderFactory);
        }
        if (jdbiCustomizer != null) {
            jdbiCustomizer.customize(jdbi);
        }
        if (this.h2IsPresent()) {
            jdbi.installPlugin((JdbiPlugin)new H2DatabasePlugin());
        }
        return jdbi;
    }

    private boolean h2IsPresent() {
        return ClassUtils.isPresent((String)"org.h2.Driver", (ClassLoader)this.getClass().getClassLoader());
    }
}

